package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IOChaosSpecFluentImpl<A extends IOChaosSpecFluent<A>> extends BaseFluent<A> implements IOChaosSpecFluent<A>{
  public IOChaosSpecFluentImpl() {
  }
  public IOChaosSpecFluentImpl(IOChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withAttr(instance.getAttr()); 
    this.withContainerNames(instance.getContainerNames()); 
    this.withDelay(instance.getDelay()); 
    this.withDuration(instance.getDuration()); 
    this.withErrno(instance.getErrno()); 
    this.withMethods(instance.getMethods()); 
    this.withMistake(instance.getMistake()); 
    this.withMode(instance.getMode()); 
    this.withPath(instance.getPath()); 
    this.withPercent(instance.getPercent()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
    this.withVolumePath(instance.getVolumePath()); 
  }
  private String action;
  private AttrOverrideSpecBuilder attr;
  private List<String> containerNames = new ArrayList<String>();
  private String delay;
  private String duration;
  private Integer errno;
  private List<String> methods = new ArrayList<String>();
  private MistakeSpecBuilder mistake;
  private String mode;
  private String path;
  private Integer percent;
  private PodSelectorSpecBuilder selector;
  private String value;
  private String volumePath;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAttr instead.
   * @return The buildable object.
   */
  @Deprecated
  public AttrOverrideSpec getAttr() {
    return this.attr!=null ?this.attr.build():null;
  }
  public AttrOverrideSpec buildAttr() {
    return this.attr!=null ?this.attr.build():null;
  }
  public A withAttr(AttrOverrideSpec attr) {
    _visitables.get("attr").remove(this.attr);
    if (attr!=null){ this.attr= new AttrOverrideSpecBuilder(attr); _visitables.get("attr").add(this.attr);} else { this.attr = null; _visitables.get("attr").remove(this.attr); } return (A) this;
  }
  public Boolean hasAttr() {
    return this.attr != null;
  }
  public IOChaosSpecFluent.AttrNested<A> withNewAttr() {
    return new IOChaosSpecFluentImpl.AttrNestedImpl();
  }
  public IOChaosSpecFluent.AttrNested<A> withNewAttrLike(AttrOverrideSpec item) {
    return new IOChaosSpecFluentImpl.AttrNestedImpl(item);
  }
  public IOChaosSpecFluent.AttrNested<A> editAttr() {
    return withNewAttrLike(getAttr());
  }
  public IOChaosSpecFluent.AttrNested<A> editOrNewAttr() {
    return withNewAttrLike(getAttr() != null ? getAttr(): new AttrOverrideSpecBuilder().build());
  }
  public IOChaosSpecFluent.AttrNested<A> editOrNewAttrLike(AttrOverrideSpec item) {
    return withNewAttrLike(getAttr() != null ? getAttr(): item);
  }
  public A addToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(Integer index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear();}
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  public String getDelay() {
    return this.delay;
  }
  public A withDelay(String delay) {
    this.delay=delay; return (A) this;
  }
  public Boolean hasDelay() {
    return this.delay != null;
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public Integer getErrno() {
    return this.errno;
  }
  public A withErrno(Integer errno) {
    this.errno=errno; return (A) this;
  }
  public Boolean hasErrno() {
    return this.errno != null;
  }
  public A addToMethods(Integer index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  public A setToMethods(Integer index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A removeFromMethods(java.lang.String... items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public A removeAllFromMethods(Collection<String> items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public List<String> getMethods() {
    return this.methods;
  }
  public String getMethod(Integer index) {
    return this.methods.get(index);
  }
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  public String getMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMethods(List<String> methods) {
    if (methods != null) {this.methods = new ArrayList(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
  }
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {this.methods.clear();}
    if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
  }
  public Boolean hasMethods() {
    return methods != null && !methods.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildMistake instead.
   * @return The buildable object.
   */
  @Deprecated
  public MistakeSpec getMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public MistakeSpec buildMistake() {
    return this.mistake!=null ?this.mistake.build():null;
  }
  public A withMistake(MistakeSpec mistake) {
    _visitables.get("mistake").remove(this.mistake);
    if (mistake!=null){ this.mistake= new MistakeSpecBuilder(mistake); _visitables.get("mistake").add(this.mistake);} else { this.mistake = null; _visitables.get("mistake").remove(this.mistake); } return (A) this;
  }
  public Boolean hasMistake() {
    return this.mistake != null;
  }
  public A withNewMistake(String filling,Long maxLength,Long maxOccurrences) {
    return (A)withMistake(new MistakeSpec(filling, maxLength, maxOccurrences));
  }
  public IOChaosSpecFluent.MistakeNested<A> withNewMistake() {
    return new IOChaosSpecFluentImpl.MistakeNestedImpl();
  }
  public IOChaosSpecFluent.MistakeNested<A> withNewMistakeLike(MistakeSpec item) {
    return new IOChaosSpecFluentImpl.MistakeNestedImpl(item);
  }
  public IOChaosSpecFluent.MistakeNested<A> editMistake() {
    return withNewMistakeLike(getMistake());
  }
  public IOChaosSpecFluent.MistakeNested<A> editOrNewMistake() {
    return withNewMistakeLike(getMistake() != null ? getMistake(): new MistakeSpecBuilder().build());
  }
  public IOChaosSpecFluent.MistakeNested<A> editOrNewMistakeLike(MistakeSpec item) {
    return withNewMistakeLike(getMistake() != null ? getMistake(): item);
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public Integer getPercent() {
    return this.percent;
  }
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  public Boolean hasPercent() {
    return this.percent != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public PodSelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(PodSelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new PodSelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public IOChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new IOChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public IOChaosSpecFluent.SelectorNested<A> withNewSelectorLike(PodSelectorSpec item) {
    return new IOChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public IOChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public IOChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new PodSelectorSpecBuilder().build());
  }
  public IOChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(PodSelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public String getVolumePath() {
    return this.volumePath;
  }
  public A withVolumePath(String volumePath) {
    this.volumePath=volumePath; return (A) this;
  }
  public Boolean hasVolumePath() {
    return this.volumePath != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IOChaosSpecFluentImpl that = (IOChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (attr != null ? !attr.equals(that.attr) :that.attr != null) return false;
    if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
    if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (errno != null ? !errno.equals(that.errno) :that.errno != null) return false;
    if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
    if (mistake != null ? !mistake.equals(that.mistake) :that.mistake != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    if (volumePath != null ? !volumePath.equals(that.volumePath) :that.volumePath != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  attr,  containerNames,  delay,  duration,  errno,  methods,  mistake,  mode,  path,  percent,  selector,  value,  volumePath,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (attr != null) { sb.append("attr:"); sb.append(attr + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (errno != null) { sb.append("errno:"); sb.append(errno + ","); }
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (mistake != null) { sb.append("mistake:"); sb.append(mistake + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (volumePath != null) { sb.append("volumePath:"); sb.append(volumePath); }
    sb.append("}");
    return sb.toString();
  }
  class AttrNestedImpl<N> extends AttrOverrideSpecFluentImpl<IOChaosSpecFluent.AttrNested<N>> implements IOChaosSpecFluent.AttrNested<N>,Nested<N>{
    AttrNestedImpl(AttrOverrideSpec item) {
      this.builder = new AttrOverrideSpecBuilder(this, item);
    }
    AttrNestedImpl() {
      this.builder = new AttrOverrideSpecBuilder(this);
    }
    AttrOverrideSpecBuilder builder;
    public N and() {
      return (N) IOChaosSpecFluentImpl.this.withAttr(builder.build());
    }
    public N endAttr() {
      return and();
    }
    
  }
  class MistakeNestedImpl<N> extends MistakeSpecFluentImpl<IOChaosSpecFluent.MistakeNested<N>> implements IOChaosSpecFluent.MistakeNested<N>,Nested<N>{
    MistakeNestedImpl(MistakeSpec item) {
      this.builder = new MistakeSpecBuilder(this, item);
    }
    MistakeNestedImpl() {
      this.builder = new MistakeSpecBuilder(this);
    }
    MistakeSpecBuilder builder;
    public N and() {
      return (N) IOChaosSpecFluentImpl.this.withMistake(builder.build());
    }
    public N endMistake() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends PodSelectorSpecFluentImpl<IOChaosSpecFluent.SelectorNested<N>> implements IOChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(PodSelectorSpec item) {
      this.builder = new PodSelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new PodSelectorSpecBuilder(this);
    }
    PodSelectorSpecBuilder builder;
    public N and() {
      return (N) IOChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}