package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPChaosStatusBuilder extends HTTPChaosStatusFluentImpl<HTTPChaosStatusBuilder> implements VisitableBuilder<HTTPChaosStatus,HTTPChaosStatusBuilder>{
  public HTTPChaosStatusBuilder() {
    this(false);
  }
  public HTTPChaosStatusBuilder(Boolean validationEnabled) {
    this(new HTTPChaosStatus(), validationEnabled);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPChaosStatus(), validationEnabled);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,HTTPChaosStatus instance) {
    this(fluent, instance, false);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,HTTPChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withInstances(instance.getInstances()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatus instance) {
    this(instance,false);
  }
  public HTTPChaosStatusBuilder(HTTPChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.withInstances(instance.getInstances()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPChaosStatus build() {
    HTTPChaosStatus buildable = new HTTPChaosStatus(fluent.getConditions(),fluent.getExperiment(),fluent.getInstances());
    return buildable;
  }
  
}