package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPChaosStatusBuilder extends GCPChaosStatusFluentImpl<GCPChaosStatusBuilder> implements VisitableBuilder<GCPChaosStatus,GCPChaosStatusBuilder>{
  public GCPChaosStatusBuilder() {
    this(false);
  }
  public GCPChaosStatusBuilder(Boolean validationEnabled) {
    this(new GCPChaosStatus(), validationEnabled);
  }
  public GCPChaosStatusBuilder(GCPChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPChaosStatusBuilder(GCPChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPChaosStatus(), validationEnabled);
  }
  public GCPChaosStatusBuilder(GCPChaosStatusFluent<?> fluent,GCPChaosStatus instance) {
    this(fluent, instance, false);
  }
  public GCPChaosStatusBuilder(GCPChaosStatusFluent<?> fluent,GCPChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttachedDiskStrings(instance.getAttachedDiskStrings()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  public GCPChaosStatusBuilder(GCPChaosStatus instance) {
    this(instance,false);
  }
  public GCPChaosStatusBuilder(GCPChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttachedDiskStrings(instance.getAttachedDiskStrings()); 
    this.withConditions(instance.getConditions()); 
    this.withExperiment(instance.getExperiment()); 
    this.validationEnabled = validationEnabled; 
  }
  GCPChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GCPChaosStatus build() {
    GCPChaosStatus buildable = new GCPChaosStatus(fluent.getAttachedDiskStrings(),fluent.getConditions(),fluent.getExperiment());
    return buildable;
  }
  
}