package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DelaySpecBuilder extends DelaySpecFluentImpl<DelaySpecBuilder> implements VisitableBuilder<DelaySpec,DelaySpecBuilder>{
  public DelaySpecBuilder() {
    this(false);
  }
  public DelaySpecBuilder(Boolean validationEnabled) {
    this(new DelaySpec(), validationEnabled);
  }
  public DelaySpecBuilder(DelaySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DelaySpecBuilder(DelaySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DelaySpec(), validationEnabled);
  }
  public DelaySpecBuilder(DelaySpecFluent<?> fluent,DelaySpec instance) {
    this(fluent, instance, false);
  }
  public DelaySpecBuilder(DelaySpecFluent<?> fluent,DelaySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCorrelation(instance.getCorrelation()); 
    fluent.withJitter(instance.getJitter()); 
    fluent.withLatency(instance.getLatency()); 
    fluent.withReorder(instance.getReorder()); 
    this.validationEnabled = validationEnabled; 
  }
  public DelaySpecBuilder(DelaySpec instance) {
    this(instance,false);
  }
  public DelaySpecBuilder(DelaySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCorrelation(instance.getCorrelation()); 
    this.withJitter(instance.getJitter()); 
    this.withLatency(instance.getLatency()); 
    this.withReorder(instance.getReorder()); 
    this.validationEnabled = validationEnabled; 
  }
  DelaySpecFluent<?> fluent;
  Boolean validationEnabled;
  public DelaySpec build() {
    DelaySpec buildable = new DelaySpec(fluent.getCorrelation(),fluent.getJitter(),fluent.getLatency(),fluent.getReorder());
    return buildable;
  }
  
}