package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSChaosListBuilder extends AWSChaosListFluentImpl<AWSChaosListBuilder> implements VisitableBuilder<AWSChaosList,AWSChaosListBuilder>{
  public AWSChaosListBuilder() {
    this(false);
  }
  public AWSChaosListBuilder(Boolean validationEnabled) {
    this(new AWSChaosList(), validationEnabled);
  }
  public AWSChaosListBuilder(AWSChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSChaosListBuilder(AWSChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSChaosList(), validationEnabled);
  }
  public AWSChaosListBuilder(AWSChaosListFluent<?> fluent,AWSChaosList instance) {
    this(fluent, instance, false);
  }
  public AWSChaosListBuilder(AWSChaosListFluent<?> fluent,AWSChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public AWSChaosListBuilder(AWSChaosList instance) {
    this(instance,false);
  }
  public AWSChaosListBuilder(AWSChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  AWSChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public AWSChaosList build() {
    AWSChaosList buildable = new AWSChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}