package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimeChaosStatusBuilder extends TimeChaosStatusFluentImpl<TimeChaosStatusBuilder> implements VisitableBuilder<TimeChaosStatus,TimeChaosStatusBuilder>{
  public TimeChaosStatusBuilder() {
    this(false);
  }
  public TimeChaosStatusBuilder(Boolean validationEnabled) {
    this(new TimeChaosStatus(), validationEnabled);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TimeChaosStatus(), validationEnabled);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,TimeChaosStatus instance) {
    this(fluent, instance, false);
  }
  public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,TimeChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  public TimeChaosStatusBuilder(TimeChaosStatus instance) {
    this(instance,false);
  }
  public TimeChaosStatusBuilder(TimeChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExperiment(instance.getExperiment()); 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  TimeChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TimeChaosStatus build() {
    TimeChaosStatus buildable = new TimeChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
    return buildable;
  }
  
}