package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TimeChaosSpecFluentImpl<A extends TimeChaosSpecFluent<A>> extends BaseFluent<A> implements TimeChaosSpecFluent<A>{
  public TimeChaosSpecFluentImpl() {
  }
  public TimeChaosSpecFluentImpl(TimeChaosSpec instance) {
    this.withClockIds(instance.getClockIds()); 
    this.withContainerNames(instance.getContainerNames()); 
    this.withDuration(instance.getDuration()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withTimeOffset(instance.getTimeOffset()); 
    this.withValue(instance.getValue()); 
  }
  private List<String> clockIds = new ArrayList<String>();
  private List<String> containerNames = new ArrayList<String>();
  private String duration;
  private String mode;
  private SchedulerSpecBuilder scheduler;
  private SelectorSpecBuilder selector;
  private String timeOffset;
  private String value;
  public A addToClockIds(Integer index,String item) {
    if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
    this.clockIds.add(index, item);
    return (A)this;
  }
  public A setToClockIds(Integer index,String item) {
    if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
    this.clockIds.set(index, item); return (A)this;
  }
  public A addToClockIds(java.lang.String... items) {
    if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
    for (String item : items) {this.clockIds.add(item);} return (A)this;
  }
  public A addAllToClockIds(Collection<String> items) {
    if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
    for (String item : items) {this.clockIds.add(item);} return (A)this;
  }
  public A removeFromClockIds(java.lang.String... items) {
    for (String item : items) {if (this.clockIds!= null){ this.clockIds.remove(item);}} return (A)this;
  }
  public A removeAllFromClockIds(Collection<String> items) {
    for (String item : items) {if (this.clockIds!= null){ this.clockIds.remove(item);}} return (A)this;
  }
  public List<String> getClockIds() {
    return this.clockIds;
  }
  public String getClockId(Integer index) {
    return this.clockIds.get(index);
  }
  public String getFirstClockId() {
    return this.clockIds.get(0);
  }
  public String getLastClockId() {
    return this.clockIds.get(clockIds.size() - 1);
  }
  public String getMatchingClockId(Predicate<String> predicate) {
    for (String item: clockIds) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingClockId(Predicate<String> predicate) {
    for (String item: clockIds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClockIds(List<String> clockIds) {
    if (clockIds != null) {this.clockIds = new ArrayList(); for (String item : clockIds){this.addToClockIds(item);}} else { this.clockIds = null;} return (A) this;
  }
  public A withClockIds(java.lang.String... clockIds) {
    if (this.clockIds != null) {this.clockIds.clear();}
    if (clockIds != null) {for (String item :clockIds){ this.addToClockIds(item);}} return (A) this;
  }
  public Boolean hasClockIds() {
    return clockIds != null && !clockIds.isEmpty();
  }
  public A addToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.add(index, item);
    return (A)this;
  }
  public A setToContainerNames(Integer index,String item) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    this.containerNames.set(index, item); return (A)this;
  }
  public A addToContainerNames(java.lang.String... items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A addAllToContainerNames(Collection<String> items) {
    if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
    for (String item : items) {this.containerNames.add(item);} return (A)this;
  }
  public A removeFromContainerNames(java.lang.String... items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public A removeAllFromContainerNames(Collection<String> items) {
    for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
  }
  public List<String> getContainerNames() {
    return this.containerNames;
  }
  public String getContainerName(Integer index) {
    return this.containerNames.get(index);
  }
  public String getFirstContainerName() {
    return this.containerNames.get(0);
  }
  public String getLastContainerName() {
    return this.containerNames.get(containerNames.size() - 1);
  }
  public String getMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingContainerName(Predicate<String> predicate) {
    for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainerNames(List<String> containerNames) {
    if (containerNames != null) {this.containerNames = new ArrayList(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
  }
  public A withContainerNames(java.lang.String... containerNames) {
    if (this.containerNames != null) {this.containerNames.clear();}
    if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
  }
  public Boolean hasContainerNames() {
    return containerNames != null && !containerNames.isEmpty();
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScheduler instead.
   * @return The buildable object.
   */
  @Deprecated
  public SchedulerSpec getScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public SchedulerSpec buildScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public A withScheduler(SchedulerSpec scheduler) {
    _visitables.get("scheduler").remove(this.scheduler);
    if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} else { this.scheduler = null; _visitables.get("scheduler").remove(this.scheduler); } return (A) this;
  }
  public Boolean hasScheduler() {
    return this.scheduler != null;
  }
  public A withNewScheduler(String cron) {
    return (A)withScheduler(new SchedulerSpec(cron));
  }
  public TimeChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
    return new TimeChaosSpecFluentImpl.SchedulerNestedImpl();
  }
  public TimeChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
    return new TimeChaosSpecFluentImpl.SchedulerNestedImpl(item);
  }
  public TimeChaosSpecFluent.SchedulerNested<A> editScheduler() {
    return withNewSchedulerLike(getScheduler());
  }
  public TimeChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
  }
  public TimeChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public SelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(SelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public TimeChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new TimeChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public TimeChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
    return new TimeChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public TimeChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public TimeChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
  }
  public TimeChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getTimeOffset() {
    return this.timeOffset;
  }
  public A withTimeOffset(String timeOffset) {
    this.timeOffset=timeOffset; return (A) this;
  }
  public Boolean hasTimeOffset() {
    return this.timeOffset != null;
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeChaosSpecFluentImpl that = (TimeChaosSpecFluentImpl) o;
    if (clockIds != null ? !clockIds.equals(that.clockIds) :that.clockIds != null) return false;
    if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (timeOffset != null ? !timeOffset.equals(that.timeOffset) :that.timeOffset != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clockIds,  containerNames,  duration,  mode,  scheduler,  selector,  timeOffset,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clockIds != null && !clockIds.isEmpty()) { sb.append("clockIds:"); sb.append(clockIds + ","); }
    if (containerNames != null && !containerNames.isEmpty()) { sb.append("containerNames:"); sb.append(containerNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (scheduler != null) { sb.append("scheduler:"); sb.append(scheduler + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (timeOffset != null) { sb.append("timeOffset:"); sb.append(timeOffset + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<TimeChaosSpecFluent.SchedulerNested<N>> implements TimeChaosSpecFluent.SchedulerNested<N>,Nested<N>{
    SchedulerNestedImpl(SchedulerSpec item) {
      this.builder = new SchedulerSpecBuilder(this, item);
    }
    SchedulerNestedImpl() {
      this.builder = new SchedulerSpecBuilder(this);
    }
    SchedulerSpecBuilder builder;
    public N and() {
      return (N) TimeChaosSpecFluentImpl.this.withScheduler(builder.build());
    }
    public N endScheduler() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<TimeChaosSpecFluent.SelectorNested<N>> implements TimeChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(SelectorSpec item) {
      this.builder = new SelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new SelectorSpecBuilder(this);
    }
    SelectorSpecBuilder builder;
    public N and() {
      return (N) TimeChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}