package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TimeChaosSpecBuilder extends TimeChaosSpecFluentImpl<TimeChaosSpecBuilder> implements VisitableBuilder<TimeChaosSpec,TimeChaosSpecBuilder>{
  public TimeChaosSpecBuilder() {
    this(false);
  }
  public TimeChaosSpecBuilder(Boolean validationEnabled) {
    this(new TimeChaosSpec(), validationEnabled);
  }
  public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TimeChaosSpec(), validationEnabled);
  }
  public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent,TimeChaosSpec instance) {
    this(fluent, instance, false);
  }
  public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent,TimeChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClockIds(instance.getClockIds()); 
    fluent.withContainerNames(instance.getContainerNames()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withMode(instance.getMode()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTimeOffset(instance.getTimeOffset()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public TimeChaosSpecBuilder(TimeChaosSpec instance) {
    this(instance,false);
  }
  public TimeChaosSpecBuilder(TimeChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClockIds(instance.getClockIds()); 
    this.withContainerNames(instance.getContainerNames()); 
    this.withDuration(instance.getDuration()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withTimeOffset(instance.getTimeOffset()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  TimeChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TimeChaosSpec build() {
    TimeChaosSpec buildable = new TimeChaosSpec(fluent.getClockIds(),fluent.getContainerNames(),fluent.getDuration(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getTimeOffset(),fluent.getValue());
    return buildable;
  }
  
}