package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StressChaosSpecBuilder extends StressChaosSpecFluentImpl<StressChaosSpecBuilder> implements VisitableBuilder<StressChaosSpec,StressChaosSpecBuilder>{
  public StressChaosSpecBuilder() {
    this(false);
  }
  public StressChaosSpecBuilder(Boolean validationEnabled) {
    this(new StressChaosSpec(), validationEnabled);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StressChaosSpec(), validationEnabled);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent,StressChaosSpec instance) {
    this(fluent, instance, false);
  }
  public StressChaosSpecBuilder(StressChaosSpecFluent<?> fluent,StressChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withMode(instance.getMode()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withStressngStressors(instance.getStressngStressors()); 
    fluent.withStressors(instance.getStressors()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public StressChaosSpecBuilder(StressChaosSpec instance) {
    this(instance,false);
  }
  public StressChaosSpecBuilder(StressChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerName(instance.getContainerName()); 
    this.withDuration(instance.getDuration()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withStressngStressors(instance.getStressngStressors()); 
    this.withStressors(instance.getStressors()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  StressChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StressChaosSpec build() {
    StressChaosSpec buildable = new StressChaosSpec(fluent.getContainerName(),fluent.getDuration(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getStressngStressors(),fluent.getStressors(),fluent.getValue());
    return buildable;
  }
  
}