package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerSpecBuilder extends SchedulerSpecFluentImpl<SchedulerSpecBuilder> implements VisitableBuilder<SchedulerSpec,SchedulerSpecBuilder>{
  public SchedulerSpecBuilder() {
    this(false);
  }
  public SchedulerSpecBuilder(Boolean validationEnabled) {
    this(new SchedulerSpec(), validationEnabled);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SchedulerSpec(), validationEnabled);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,SchedulerSpec instance) {
    this(fluent, instance, false);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent,SchedulerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCron(instance.getCron()); 
    this.validationEnabled = validationEnabled; 
  }
  public SchedulerSpecBuilder(SchedulerSpec instance) {
    this(instance,false);
  }
  public SchedulerSpecBuilder(SchedulerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCron(instance.getCron()); 
    this.validationEnabled = validationEnabled; 
  }
  SchedulerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SchedulerSpec build() {
    SchedulerSpec buildable = new SchedulerSpec(fluent.getCron());
    return buildable;
  }
  
}