package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScheduleStatusBuilder extends ScheduleStatusFluentImpl<ScheduleStatusBuilder> implements VisitableBuilder<ScheduleStatus,ScheduleStatusBuilder>{
  public ScheduleStatusBuilder() {
    this(false);
  }
  public ScheduleStatusBuilder(Boolean validationEnabled) {
    this(new ScheduleStatus(), validationEnabled);
  }
  public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScheduleStatus(), validationEnabled);
  }
  public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent,ScheduleStatus instance) {
    this(fluent, instance, false);
  }
  public ScheduleStatusBuilder(ScheduleStatusFluent<?> fluent,ScheduleStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNextRecover(instance.getNextRecover()); 
    fluent.withNextStart(instance.getNextStart()); 
    this.validationEnabled = validationEnabled; 
  }
  public ScheduleStatusBuilder(ScheduleStatus instance) {
    this(instance,false);
  }
  public ScheduleStatusBuilder(ScheduleStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNextRecover(instance.getNextRecover()); 
    this.withNextStart(instance.getNextStart()); 
    this.validationEnabled = validationEnabled; 
  }
  ScheduleStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ScheduleStatus build() {
    ScheduleStatus buildable = new ScheduleStatus(fluent.getNextRecover(),fluent.getNextStart());
    return buildable;
  }
  
}