package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RawTrafficControlBuilder extends RawTrafficControlFluentImpl<RawTrafficControlBuilder> implements VisitableBuilder<RawTrafficControl,RawTrafficControlBuilder>{
  public RawTrafficControlBuilder() {
    this(false);
  }
  public RawTrafficControlBuilder(Boolean validationEnabled) {
    this(new RawTrafficControl(), validationEnabled);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent) {
    this(fluent, false);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RawTrafficControl(), validationEnabled);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent,RawTrafficControl instance) {
    this(fluent, instance, false);
  }
  public RawTrafficControlBuilder(RawTrafficControlFluent<?> fluent,RawTrafficControl instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBandwidth(instance.getBandwidth()); 
    fluent.withCorrupt(instance.getCorrupt()); 
    fluent.withDelay(instance.getDelay()); 
    fluent.withDuplicate(instance.getDuplicate()); 
    fluent.withIpset(instance.getIpset()); 
    fluent.withLoss(instance.getLoss()); 
    fluent.withSource(instance.getSource()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public RawTrafficControlBuilder(RawTrafficControl instance) {
    this(instance,false);
  }
  public RawTrafficControlBuilder(RawTrafficControl instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBandwidth(instance.getBandwidth()); 
    this.withCorrupt(instance.getCorrupt()); 
    this.withDelay(instance.getDelay()); 
    this.withDuplicate(instance.getDuplicate()); 
    this.withIpset(instance.getIpset()); 
    this.withLoss(instance.getLoss()); 
    this.withSource(instance.getSource()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  RawTrafficControlFluent<?> fluent;
  Boolean validationEnabled;
  public RawTrafficControl build() {
    RawTrafficControl buildable = new RawTrafficControl(fluent.getBandwidth(),fluent.getCorrupt(),fluent.getDelay(),fluent.getDuplicate(),fluent.getIpset(),fluent.getLoss(),fluent.getSource(),fluent.getType());
    return buildable;
  }
  
}