package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RawIptablesBuilder extends RawIptablesFluentImpl<RawIptablesBuilder> implements VisitableBuilder<RawIptables,RawIptablesBuilder>{
  public RawIptablesBuilder() {
    this(false);
  }
  public RawIptablesBuilder(Boolean validationEnabled) {
    this(new RawIptables(), validationEnabled);
  }
  public RawIptablesBuilder(RawIptablesFluent<?> fluent) {
    this(fluent, false);
  }
  public RawIptablesBuilder(RawIptablesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RawIptables(), validationEnabled);
  }
  public RawIptablesBuilder(RawIptablesFluent<?> fluent,RawIptables instance) {
    this(fluent, instance, false);
  }
  public RawIptablesBuilder(RawIptablesFluent<?> fluent,RawIptables instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDirection(instance.getDirection()); 
    fluent.withIpsets(instance.getIpsets()); 
    fluent.withName(instance.getName()); 
    fluent.withSource(instance.getSource()); 
    this.validationEnabled = validationEnabled; 
  }
  public RawIptablesBuilder(RawIptables instance) {
    this(instance,false);
  }
  public RawIptablesBuilder(RawIptables instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDirection(instance.getDirection()); 
    this.withIpsets(instance.getIpsets()); 
    this.withName(instance.getName()); 
    this.withSource(instance.getSource()); 
    this.validationEnabled = validationEnabled; 
  }
  RawIptablesFluent<?> fluent;
  Boolean validationEnabled;
  public RawIptables build() {
    RawIptables buildable = new RawIptables(fluent.getDirection(),fluent.getIpsets(),fluent.getName(),fluent.getSource());
    return buildable;
  }
  
}