package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodStatusBuilder extends PodStatusFluentImpl<PodStatusBuilder> implements VisitableBuilder<PodStatus,PodStatusBuilder>{
  public PodStatusBuilder() {
    this(false);
  }
  public PodStatusBuilder(Boolean validationEnabled) {
    this(new PodStatus(), validationEnabled);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodStatus(), validationEnabled);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent,PodStatus instance) {
    this(fluent, instance, false);
  }
  public PodStatusBuilder(PodStatusFluent<?> fluent,PodStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withHostIP(instance.getHostIP()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPodIP(instance.getPodIP()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodStatusBuilder(PodStatus instance) {
    this(instance,false);
  }
  public PodStatusBuilder(PodStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withHostIP(instance.getHostIP()); 
    this.withMessage(instance.getMessage()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPodIP(instance.getPodIP()); 
    this.validationEnabled = validationEnabled; 
  }
  PodStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodStatus build() {
    PodStatus buildable = new PodStatus(fluent.getAction(),fluent.getHostIP(),fluent.getMessage(),fluent.getName(),fluent.getNamespace(),fluent.getPodIP());
    return buildable;
  }
  
}