package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIoChaosListBuilder extends PodIoChaosListFluentImpl<PodIoChaosListBuilder> implements VisitableBuilder<PodIoChaosList,PodIoChaosListBuilder>{
  public PodIoChaosListBuilder() {
    this(false);
  }
  public PodIoChaosListBuilder(Boolean validationEnabled) {
    this(new PodIoChaosList(), validationEnabled);
  }
  public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIoChaosList(), validationEnabled);
  }
  public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent,PodIoChaosList instance) {
    this(fluent, instance, false);
  }
  public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent,PodIoChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodIoChaosListBuilder(PodIoChaosList instance) {
    this(instance,false);
  }
  public PodIoChaosListBuilder(PodIoChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  PodIoChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public PodIoChaosList build() {
    PodIoChaosList buildable = new PodIoChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}