package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodIoChaosBuilder extends PodIoChaosFluentImpl<PodIoChaosBuilder> implements VisitableBuilder<PodIoChaos,PodIoChaosBuilder>{
  public PodIoChaosBuilder() {
    this(false);
  }
  public PodIoChaosBuilder(Boolean validationEnabled) {
    this(new PodIoChaos(), validationEnabled);
  }
  public PodIoChaosBuilder(PodIoChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public PodIoChaosBuilder(PodIoChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodIoChaos(), validationEnabled);
  }
  public PodIoChaosBuilder(PodIoChaosFluent<?> fluent,PodIoChaos instance) {
    this(fluent, instance, false);
  }
  public PodIoChaosBuilder(PodIoChaosFluent<?> fluent,PodIoChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodIoChaosBuilder(PodIoChaos instance) {
    this(instance,false);
  }
  public PodIoChaosBuilder(PodIoChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.validationEnabled = validationEnabled; 
  }
  PodIoChaosFluent<?> fluent;
  Boolean validationEnabled;
  public PodIoChaos build() {
    PodIoChaos buildable = new PodIoChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    return buildable;
  }
  
}