package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodChaosSpecBuilder extends PodChaosSpecFluentImpl<PodChaosSpecBuilder> implements VisitableBuilder<PodChaosSpec,PodChaosSpecBuilder>{
  public PodChaosSpecBuilder() {
    this(false);
  }
  public PodChaosSpecBuilder(Boolean validationEnabled) {
    this(new PodChaosSpec(), validationEnabled);
  }
  public PodChaosSpecBuilder(PodChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodChaosSpecBuilder(PodChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodChaosSpec(), validationEnabled);
  }
  public PodChaosSpecBuilder(PodChaosSpecFluent<?> fluent,PodChaosSpec instance) {
    this(fluent, instance, false);
  }
  public PodChaosSpecBuilder(PodChaosSpecFluent<?> fluent,PodChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withGracePeriod(instance.getGracePeriod()); 
    fluent.withMode(instance.getMode()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public PodChaosSpecBuilder(PodChaosSpec instance) {
    this(instance,false);
  }
  public PodChaosSpecBuilder(PodChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withContainerName(instance.getContainerName()); 
    this.withDuration(instance.getDuration()); 
    this.withGracePeriod(instance.getGracePeriod()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  PodChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodChaosSpec build() {
    PodChaosSpec buildable = new PodChaosSpec(fluent.getAction(),fluent.getContainerName(),fluent.getDuration(),fluent.getGracePeriod(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getValue());
    return buildable;
  }
  
}