package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkChaosStatusBuilder extends NetworkChaosStatusFluentImpl<NetworkChaosStatusBuilder> implements VisitableBuilder<NetworkChaosStatus,NetworkChaosStatusBuilder>{
  public NetworkChaosStatusBuilder() {
    this(false);
  }
  public NetworkChaosStatusBuilder(Boolean validationEnabled) {
    this(new NetworkChaosStatus(), validationEnabled);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkChaosStatus(), validationEnabled);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,NetworkChaosStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatusFluent<?> fluent,NetworkChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatus instance) {
    this(instance,false);
  }
  public NetworkChaosStatusBuilder(NetworkChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExperiment(instance.getExperiment()); 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  NetworkChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkChaosStatus build() {
    NetworkChaosStatus buildable = new NetworkChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
    return buildable;
  }
  
}