package io.fabric8.chaosmesh.v1alpha1;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkChaosSpecFluentImpl<A extends NetworkChaosSpecFluent<A>> extends BaseFluent<A> implements NetworkChaosSpecFluent<A>{
  public NetworkChaosSpecFluentImpl() {
  }
  public NetworkChaosSpecFluentImpl(NetworkChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withBandwidth(instance.getBandwidth()); 
    this.withCorrupt(instance.getCorrupt()); 
    this.withDelay(instance.getDelay()); 
    this.withDirection(instance.getDirection()); 
    this.withDuplicate(instance.getDuplicate()); 
    this.withDuration(instance.getDuration()); 
    this.withExternalTargets(instance.getExternalTargets()); 
    this.withLoss(instance.getLoss()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withValue(instance.getValue()); 
  }
  private String action;
  private BandwidthSpecBuilder bandwidth;
  private CorruptSpecBuilder corrupt;
  private DelaySpecBuilder delay;
  private String direction;
  private DuplicateSpecBuilder duplicate;
  private String duration;
  private List<String> externalTargets = new ArrayList<String>();
  private LossSpecBuilder loss;
  private String mode;
  private SchedulerSpecBuilder scheduler;
  private SelectorSpecBuilder selector;
  private TargetBuilder target;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBandwidth instead.
   * @return The buildable object.
   */
  @Deprecated
  public BandwidthSpec getBandwidth() {
    return this.bandwidth!=null ?this.bandwidth.build():null;
  }
  public BandwidthSpec buildBandwidth() {
    return this.bandwidth!=null ?this.bandwidth.build():null;
  }
  public A withBandwidth(BandwidthSpec bandwidth) {
    _visitables.get("bandwidth").remove(this.bandwidth);
    if (bandwidth!=null){ this.bandwidth= new BandwidthSpecBuilder(bandwidth); _visitables.get("bandwidth").add(this.bandwidth);} else { this.bandwidth = null; _visitables.get("bandwidth").remove(this.bandwidth); } return (A) this;
  }
  public Boolean hasBandwidth() {
    return this.bandwidth != null;
  }
  public A withNewBandwidth(Integer buffer,Integer limit,Long minburst,Long peakrate,String rate) {
    return (A)withBandwidth(new BandwidthSpec(buffer, limit, minburst, peakrate, rate));
  }
  public NetworkChaosSpecFluent.BandwidthNested<A> withNewBandwidth() {
    return new NetworkChaosSpecFluentImpl.BandwidthNestedImpl();
  }
  public NetworkChaosSpecFluent.BandwidthNested<A> withNewBandwidthLike(BandwidthSpec item) {
    return new NetworkChaosSpecFluentImpl.BandwidthNestedImpl(item);
  }
  public NetworkChaosSpecFluent.BandwidthNested<A> editBandwidth() {
    return withNewBandwidthLike(getBandwidth());
  }
  public NetworkChaosSpecFluent.BandwidthNested<A> editOrNewBandwidth() {
    return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): new BandwidthSpecBuilder().build());
  }
  public NetworkChaosSpecFluent.BandwidthNested<A> editOrNewBandwidthLike(BandwidthSpec item) {
    return withNewBandwidthLike(getBandwidth() != null ? getBandwidth(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCorrupt instead.
   * @return The buildable object.
   */
  @Deprecated
  public CorruptSpec getCorrupt() {
    return this.corrupt!=null ?this.corrupt.build():null;
  }
  public CorruptSpec buildCorrupt() {
    return this.corrupt!=null ?this.corrupt.build():null;
  }
  public A withCorrupt(CorruptSpec corrupt) {
    _visitables.get("corrupt").remove(this.corrupt);
    if (corrupt!=null){ this.corrupt= new CorruptSpecBuilder(corrupt); _visitables.get("corrupt").add(this.corrupt);} else { this.corrupt = null; _visitables.get("corrupt").remove(this.corrupt); } return (A) this;
  }
  public Boolean hasCorrupt() {
    return this.corrupt != null;
  }
  public A withNewCorrupt(String correlation,String corrupt) {
    return (A)withCorrupt(new CorruptSpec(correlation, corrupt));
  }
  public NetworkChaosSpecFluent.CorruptNested<A> withNewCorrupt() {
    return new NetworkChaosSpecFluentImpl.CorruptNestedImpl();
  }
  public NetworkChaosSpecFluent.CorruptNested<A> withNewCorruptLike(CorruptSpec item) {
    return new NetworkChaosSpecFluentImpl.CorruptNestedImpl(item);
  }
  public NetworkChaosSpecFluent.CorruptNested<A> editCorrupt() {
    return withNewCorruptLike(getCorrupt());
  }
  public NetworkChaosSpecFluent.CorruptNested<A> editOrNewCorrupt() {
    return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): new CorruptSpecBuilder().build());
  }
  public NetworkChaosSpecFluent.CorruptNested<A> editOrNewCorruptLike(CorruptSpec item) {
    return withNewCorruptLike(getCorrupt() != null ? getCorrupt(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDelay instead.
   * @return The buildable object.
   */
  @Deprecated
  public DelaySpec getDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public DelaySpec buildDelay() {
    return this.delay!=null ?this.delay.build():null;
  }
  public A withDelay(DelaySpec delay) {
    _visitables.get("delay").remove(this.delay);
    if (delay!=null){ this.delay= new DelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} else { this.delay = null; _visitables.get("delay").remove(this.delay); } return (A) this;
  }
  public Boolean hasDelay() {
    return this.delay != null;
  }
  public NetworkChaosSpecFluent.DelayNested<A> withNewDelay() {
    return new NetworkChaosSpecFluentImpl.DelayNestedImpl();
  }
  public NetworkChaosSpecFluent.DelayNested<A> withNewDelayLike(DelaySpec item) {
    return new NetworkChaosSpecFluentImpl.DelayNestedImpl(item);
  }
  public NetworkChaosSpecFluent.DelayNested<A> editDelay() {
    return withNewDelayLike(getDelay());
  }
  public NetworkChaosSpecFluent.DelayNested<A> editOrNewDelay() {
    return withNewDelayLike(getDelay() != null ? getDelay(): new DelaySpecBuilder().build());
  }
  public NetworkChaosSpecFluent.DelayNested<A> editOrNewDelayLike(DelaySpec item) {
    return withNewDelayLike(getDelay() != null ? getDelay(): item);
  }
  public String getDirection() {
    return this.direction;
  }
  public A withDirection(String direction) {
    this.direction=direction; return (A) this;
  }
  public Boolean hasDirection() {
    return this.direction != null;
  }
  
  /**
   * This method has been deprecated, please use method buildDuplicate instead.
   * @return The buildable object.
   */
  @Deprecated
  public DuplicateSpec getDuplicate() {
    return this.duplicate!=null ?this.duplicate.build():null;
  }
  public DuplicateSpec buildDuplicate() {
    return this.duplicate!=null ?this.duplicate.build():null;
  }
  public A withDuplicate(DuplicateSpec duplicate) {
    _visitables.get("duplicate").remove(this.duplicate);
    if (duplicate!=null){ this.duplicate= new DuplicateSpecBuilder(duplicate); _visitables.get("duplicate").add(this.duplicate);} else { this.duplicate = null; _visitables.get("duplicate").remove(this.duplicate); } return (A) this;
  }
  public Boolean hasDuplicate() {
    return this.duplicate != null;
  }
  public A withNewDuplicate(String correlation,String duplicate) {
    return (A)withDuplicate(new DuplicateSpec(correlation, duplicate));
  }
  public NetworkChaosSpecFluent.DuplicateNested<A> withNewDuplicate() {
    return new NetworkChaosSpecFluentImpl.DuplicateNestedImpl();
  }
  public NetworkChaosSpecFluent.DuplicateNested<A> withNewDuplicateLike(DuplicateSpec item) {
    return new NetworkChaosSpecFluentImpl.DuplicateNestedImpl(item);
  }
  public NetworkChaosSpecFluent.DuplicateNested<A> editDuplicate() {
    return withNewDuplicateLike(getDuplicate());
  }
  public NetworkChaosSpecFluent.DuplicateNested<A> editOrNewDuplicate() {
    return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): new DuplicateSpecBuilder().build());
  }
  public NetworkChaosSpecFluent.DuplicateNested<A> editOrNewDuplicateLike(DuplicateSpec item) {
    return withNewDuplicateLike(getDuplicate() != null ? getDuplicate(): item);
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToExternalTargets(Integer index,String item) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    this.externalTargets.add(index, item);
    return (A)this;
  }
  public A setToExternalTargets(Integer index,String item) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    this.externalTargets.set(index, item); return (A)this;
  }
  public A addToExternalTargets(java.lang.String... items) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    for (String item : items) {this.externalTargets.add(item);} return (A)this;
  }
  public A addAllToExternalTargets(Collection<String> items) {
    if (this.externalTargets == null) {this.externalTargets = new ArrayList<String>();}
    for (String item : items) {this.externalTargets.add(item);} return (A)this;
  }
  public A removeFromExternalTargets(java.lang.String... items) {
    for (String item : items) {if (this.externalTargets!= null){ this.externalTargets.remove(item);}} return (A)this;
  }
  public A removeAllFromExternalTargets(Collection<String> items) {
    for (String item : items) {if (this.externalTargets!= null){ this.externalTargets.remove(item);}} return (A)this;
  }
  public List<String> getExternalTargets() {
    return this.externalTargets;
  }
  public String getExternalTarget(Integer index) {
    return this.externalTargets.get(index);
  }
  public String getFirstExternalTarget() {
    return this.externalTargets.get(0);
  }
  public String getLastExternalTarget() {
    return this.externalTargets.get(externalTargets.size() - 1);
  }
  public String getMatchingExternalTarget(Predicate<String> predicate) {
    for (String item: externalTargets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExternalTarget(Predicate<String> predicate) {
    for (String item: externalTargets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExternalTargets(List<String> externalTargets) {
    if (externalTargets != null) {this.externalTargets = new ArrayList(); for (String item : externalTargets){this.addToExternalTargets(item);}} else { this.externalTargets = null;} return (A) this;
  }
  public A withExternalTargets(java.lang.String... externalTargets) {
    if (this.externalTargets != null) {this.externalTargets.clear();}
    if (externalTargets != null) {for (String item :externalTargets){ this.addToExternalTargets(item);}} return (A) this;
  }
  public Boolean hasExternalTargets() {
    return externalTargets != null && !externalTargets.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildLoss instead.
   * @return The buildable object.
   */
  @Deprecated
  public LossSpec getLoss() {
    return this.loss!=null ?this.loss.build():null;
  }
  public LossSpec buildLoss() {
    return this.loss!=null ?this.loss.build():null;
  }
  public A withLoss(LossSpec loss) {
    _visitables.get("loss").remove(this.loss);
    if (loss!=null){ this.loss= new LossSpecBuilder(loss); _visitables.get("loss").add(this.loss);} else { this.loss = null; _visitables.get("loss").remove(this.loss); } return (A) this;
  }
  public Boolean hasLoss() {
    return this.loss != null;
  }
  public A withNewLoss(String correlation,String loss) {
    return (A)withLoss(new LossSpec(correlation, loss));
  }
  public NetworkChaosSpecFluent.LossNested<A> withNewLoss() {
    return new NetworkChaosSpecFluentImpl.LossNestedImpl();
  }
  public NetworkChaosSpecFluent.LossNested<A> withNewLossLike(LossSpec item) {
    return new NetworkChaosSpecFluentImpl.LossNestedImpl(item);
  }
  public NetworkChaosSpecFluent.LossNested<A> editLoss() {
    return withNewLossLike(getLoss());
  }
  public NetworkChaosSpecFluent.LossNested<A> editOrNewLoss() {
    return withNewLossLike(getLoss() != null ? getLoss(): new LossSpecBuilder().build());
  }
  public NetworkChaosSpecFluent.LossNested<A> editOrNewLossLike(LossSpec item) {
    return withNewLossLike(getLoss() != null ? getLoss(): item);
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScheduler instead.
   * @return The buildable object.
   */
  @Deprecated
  public SchedulerSpec getScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public SchedulerSpec buildScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public A withScheduler(SchedulerSpec scheduler) {
    _visitables.get("scheduler").remove(this.scheduler);
    if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} else { this.scheduler = null; _visitables.get("scheduler").remove(this.scheduler); } return (A) this;
  }
  public Boolean hasScheduler() {
    return this.scheduler != null;
  }
  public A withNewScheduler(String cron) {
    return (A)withScheduler(new SchedulerSpec(cron));
  }
  public NetworkChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
    return new NetworkChaosSpecFluentImpl.SchedulerNestedImpl();
  }
  public NetworkChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
    return new NetworkChaosSpecFluentImpl.SchedulerNestedImpl(item);
  }
  public NetworkChaosSpecFluent.SchedulerNested<A> editScheduler() {
    return withNewSchedulerLike(getScheduler());
  }
  public NetworkChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
  }
  public NetworkChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public SelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(SelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public NetworkChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new NetworkChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public NetworkChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
    return new NetworkChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public NetworkChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public NetworkChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
  }
  public NetworkChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @Deprecated
  public Target getTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public Target buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(Target target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new TargetBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public NetworkChaosSpecFluent.TargetNested<A> withNewTarget() {
    return new NetworkChaosSpecFluentImpl.TargetNestedImpl();
  }
  public NetworkChaosSpecFluent.TargetNested<A> withNewTargetLike(Target item) {
    return new NetworkChaosSpecFluentImpl.TargetNestedImpl(item);
  }
  public NetworkChaosSpecFluent.TargetNested<A> editTarget() {
    return withNewTargetLike(getTarget());
  }
  public NetworkChaosSpecFluent.TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(getTarget() != null ? getTarget(): new TargetBuilder().build());
  }
  public NetworkChaosSpecFluent.TargetNested<A> editOrNewTargetLike(Target item) {
    return withNewTargetLike(getTarget() != null ? getTarget(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkChaosSpecFluentImpl that = (NetworkChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (bandwidth != null ? !bandwidth.equals(that.bandwidth) :that.bandwidth != null) return false;
    if (corrupt != null ? !corrupt.equals(that.corrupt) :that.corrupt != null) return false;
    if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
    if (direction != null ? !direction.equals(that.direction) :that.direction != null) return false;
    if (duplicate != null ? !duplicate.equals(that.duplicate) :that.duplicate != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (externalTargets != null ? !externalTargets.equals(that.externalTargets) :that.externalTargets != null) return false;
    if (loss != null ? !loss.equals(that.loss) :that.loss != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (target != null ? !target.equals(that.target) :that.target != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  bandwidth,  corrupt,  delay,  direction,  duplicate,  duration,  externalTargets,  loss,  mode,  scheduler,  selector,  target,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (bandwidth != null) { sb.append("bandwidth:"); sb.append(bandwidth + ","); }
    if (corrupt != null) { sb.append("corrupt:"); sb.append(corrupt + ","); }
    if (delay != null) { sb.append("delay:"); sb.append(delay + ","); }
    if (direction != null) { sb.append("direction:"); sb.append(direction + ","); }
    if (duplicate != null) { sb.append("duplicate:"); sb.append(duplicate + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (externalTargets != null && !externalTargets.isEmpty()) { sb.append("externalTargets:"); sb.append(externalTargets + ","); }
    if (loss != null) { sb.append("loss:"); sb.append(loss + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (scheduler != null) { sb.append("scheduler:"); sb.append(scheduler + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class BandwidthNestedImpl<N> extends BandwidthSpecFluentImpl<NetworkChaosSpecFluent.BandwidthNested<N>> implements NetworkChaosSpecFluent.BandwidthNested<N>,Nested<N>{
    BandwidthNestedImpl(BandwidthSpec item) {
      this.builder = new BandwidthSpecBuilder(this, item);
    }
    BandwidthNestedImpl() {
      this.builder = new BandwidthSpecBuilder(this);
    }
    BandwidthSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withBandwidth(builder.build());
    }
    public N endBandwidth() {
      return and();
    }
    
  }
  class CorruptNestedImpl<N> extends CorruptSpecFluentImpl<NetworkChaosSpecFluent.CorruptNested<N>> implements NetworkChaosSpecFluent.CorruptNested<N>,Nested<N>{
    CorruptNestedImpl(CorruptSpec item) {
      this.builder = new CorruptSpecBuilder(this, item);
    }
    CorruptNestedImpl() {
      this.builder = new CorruptSpecBuilder(this);
    }
    CorruptSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withCorrupt(builder.build());
    }
    public N endCorrupt() {
      return and();
    }
    
  }
  class DelayNestedImpl<N> extends DelaySpecFluentImpl<NetworkChaosSpecFluent.DelayNested<N>> implements NetworkChaosSpecFluent.DelayNested<N>,Nested<N>{
    DelayNestedImpl(DelaySpec item) {
      this.builder = new DelaySpecBuilder(this, item);
    }
    DelayNestedImpl() {
      this.builder = new DelaySpecBuilder(this);
    }
    DelaySpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withDelay(builder.build());
    }
    public N endDelay() {
      return and();
    }
    
  }
  class DuplicateNestedImpl<N> extends DuplicateSpecFluentImpl<NetworkChaosSpecFluent.DuplicateNested<N>> implements NetworkChaosSpecFluent.DuplicateNested<N>,Nested<N>{
    DuplicateNestedImpl(DuplicateSpec item) {
      this.builder = new DuplicateSpecBuilder(this, item);
    }
    DuplicateNestedImpl() {
      this.builder = new DuplicateSpecBuilder(this);
    }
    DuplicateSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withDuplicate(builder.build());
    }
    public N endDuplicate() {
      return and();
    }
    
  }
  class LossNestedImpl<N> extends LossSpecFluentImpl<NetworkChaosSpecFluent.LossNested<N>> implements NetworkChaosSpecFluent.LossNested<N>,Nested<N>{
    LossNestedImpl(LossSpec item) {
      this.builder = new LossSpecBuilder(this, item);
    }
    LossNestedImpl() {
      this.builder = new LossSpecBuilder(this);
    }
    LossSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withLoss(builder.build());
    }
    public N endLoss() {
      return and();
    }
    
  }
  class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<NetworkChaosSpecFluent.SchedulerNested<N>> implements NetworkChaosSpecFluent.SchedulerNested<N>,Nested<N>{
    SchedulerNestedImpl(SchedulerSpec item) {
      this.builder = new SchedulerSpecBuilder(this, item);
    }
    SchedulerNestedImpl() {
      this.builder = new SchedulerSpecBuilder(this);
    }
    SchedulerSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withScheduler(builder.build());
    }
    public N endScheduler() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<NetworkChaosSpecFluent.SelectorNested<N>> implements NetworkChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(SelectorSpec item) {
      this.builder = new SelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new SelectorSpecBuilder(this);
    }
    SelectorSpecBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TargetNestedImpl<N> extends TargetFluentImpl<NetworkChaosSpecFluent.TargetNested<N>> implements NetworkChaosSpecFluent.TargetNested<N>,Nested<N>{
    TargetNestedImpl(Target item) {
      this.builder = new TargetBuilder(this, item);
    }
    TargetNestedImpl() {
      this.builder = new TargetBuilder(this);
    }
    TargetBuilder builder;
    public N and() {
      return (N) NetworkChaosSpecFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}