package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkChaosListBuilder extends NetworkChaosListFluentImpl<NetworkChaosListBuilder> implements VisitableBuilder<NetworkChaosList,NetworkChaosListBuilder>{
  public NetworkChaosListBuilder() {
    this(false);
  }
  public NetworkChaosListBuilder(Boolean validationEnabled) {
    this(new NetworkChaosList(), validationEnabled);
  }
  public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkChaosList(), validationEnabled);
  }
  public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent,NetworkChaosList instance) {
    this(fluent, instance, false);
  }
  public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent,NetworkChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public NetworkChaosListBuilder(NetworkChaosList instance) {
    this(instance,false);
  }
  public NetworkChaosListBuilder(NetworkChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  NetworkChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkChaosList build() {
    NetworkChaosList buildable = new NetworkChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}