package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MemoryStressorFluentImpl<A extends MemoryStressorFluent<A>> extends BaseFluent<A> implements MemoryStressorFluent<A>{
  public MemoryStressorFluentImpl() {
  }
  public MemoryStressorFluentImpl(MemoryStressor instance) {
    this.withOptions(instance.getOptions()); 
    this.withSize(instance.getSize()); 
    this.withWorkers(instance.getWorkers()); 
  }
  private List<String> options = new ArrayList<String>();
  private String size;
  private Integer workers;
  public A addToOptions(Integer index,String item) {
    if (this.options == null) {this.options = new ArrayList<String>();}
    this.options.add(index, item);
    return (A)this;
  }
  public A setToOptions(Integer index,String item) {
    if (this.options == null) {this.options = new ArrayList<String>();}
    this.options.set(index, item); return (A)this;
  }
  public A addToOptions(java.lang.String... items) {
    if (this.options == null) {this.options = new ArrayList<String>();}
    for (String item : items) {this.options.add(item);} return (A)this;
  }
  public A addAllToOptions(Collection<String> items) {
    if (this.options == null) {this.options = new ArrayList<String>();}
    for (String item : items) {this.options.add(item);} return (A)this;
  }
  public A removeFromOptions(java.lang.String... items) {
    for (String item : items) {if (this.options!= null){ this.options.remove(item);}} return (A)this;
  }
  public A removeAllFromOptions(Collection<String> items) {
    for (String item : items) {if (this.options!= null){ this.options.remove(item);}} return (A)this;
  }
  public List<String> getOptions() {
    return this.options;
  }
  public String getOption(Integer index) {
    return this.options.get(index);
  }
  public String getFirstOption() {
    return this.options.get(0);
  }
  public String getLastOption() {
    return this.options.get(options.size() - 1);
  }
  public String getMatchingOption(Predicate<String> predicate) {
    for (String item: options) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingOption(Predicate<String> predicate) {
    for (String item: options) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOptions(List<String> options) {
    if (options != null) {this.options = new ArrayList(); for (String item : options){this.addToOptions(item);}} else { this.options = null;} return (A) this;
  }
  public A withOptions(java.lang.String... options) {
    if (this.options != null) {this.options.clear();}
    if (options != null) {for (String item :options){ this.addToOptions(item);}} return (A) this;
  }
  public Boolean hasOptions() {
    return options != null && !options.isEmpty();
  }
  public String getSize() {
    return this.size;
  }
  public A withSize(String size) {
    this.size=size; return (A) this;
  }
  public Boolean hasSize() {
    return this.size != null;
  }
  public Integer getWorkers() {
    return this.workers;
  }
  public A withWorkers(Integer workers) {
    this.workers=workers; return (A) this;
  }
  public Boolean hasWorkers() {
    return this.workers != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MemoryStressorFluentImpl that = (MemoryStressorFluentImpl) o;
    if (options != null ? !options.equals(that.options) :that.options != null) return false;
    if (size != null ? !size.equals(that.size) :that.size != null) return false;
    if (workers != null ? !workers.equals(that.workers) :that.workers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(options,  size,  workers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (options != null && !options.isEmpty()) { sb.append("options:"); sb.append(options + ","); }
    if (size != null) { sb.append("size:"); sb.append(size + ","); }
    if (workers != null) { sb.append("workers:"); sb.append(workers); }
    sb.append("}");
    return sb.toString();
  }
  
}