package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MatcherBuilder extends MatcherFluentImpl<MatcherBuilder> implements VisitableBuilder<Matcher,MatcherBuilder>{
  public MatcherBuilder() {
    this(false);
  }
  public MatcherBuilder(Boolean validationEnabled) {
    this(new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent) {
    this(fluent, false);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Matcher(), validationEnabled);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance) {
    this(fluent, instance, false);
  }
  public MatcherBuilder(MatcherFluent<?> fluent,Matcher instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExactMatch(instance.getExactMatch()); 
    fluent.withInvertMatch(instance.getInvertMatch()); 
    fluent.withName(instance.getName()); 
    fluent.withPrefixMatch(instance.getPrefixMatch()); 
    fluent.withPresentMatch(instance.getPresentMatch()); 
    fluent.withRangeMatch(instance.getRangeMatch()); 
    fluent.withRegexMatch(instance.getRegexMatch()); 
    fluent.withSafeRegexMatch(instance.getSafeRegexMatch()); 
    fluent.withSuffixMatch(instance.getSuffixMatch()); 
    this.validationEnabled = validationEnabled; 
  }
  public MatcherBuilder(Matcher instance) {
    this(instance,false);
  }
  public MatcherBuilder(Matcher instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExactMatch(instance.getExactMatch()); 
    this.withInvertMatch(instance.getInvertMatch()); 
    this.withName(instance.getName()); 
    this.withPrefixMatch(instance.getPrefixMatch()); 
    this.withPresentMatch(instance.getPresentMatch()); 
    this.withRangeMatch(instance.getRangeMatch()); 
    this.withRegexMatch(instance.getRegexMatch()); 
    this.withSafeRegexMatch(instance.getSafeRegexMatch()); 
    this.withSuffixMatch(instance.getSuffixMatch()); 
    this.validationEnabled = validationEnabled; 
  }
  MatcherFluent<?> fluent;
  Boolean validationEnabled;
  public Matcher build() {
    Matcher buildable = new Matcher(fluent.getExactMatch(),fluent.getInvertMatch(),fluent.getName(),fluent.getPrefixMatch(),fluent.getPresentMatch(),fluent.getRangeMatch(),fluent.getRegexMatch(),fluent.getSafeRegexMatch(),fluent.getSuffixMatch());
    return buildable;
  }
  
}