package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KernelChaosStatusBuilder extends KernelChaosStatusFluentImpl<KernelChaosStatusBuilder> implements VisitableBuilder<KernelChaosStatus,KernelChaosStatusBuilder>{
  public KernelChaosStatusBuilder() {
    this(false);
  }
  public KernelChaosStatusBuilder(Boolean validationEnabled) {
    this(new KernelChaosStatus(), validationEnabled);
  }
  public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KernelChaosStatus(), validationEnabled);
  }
  public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent,KernelChaosStatus instance) {
    this(fluent, instance, false);
  }
  public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent,KernelChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  public KernelChaosStatusBuilder(KernelChaosStatus instance) {
    this(instance,false);
  }
  public KernelChaosStatusBuilder(KernelChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExperiment(instance.getExperiment()); 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  KernelChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public KernelChaosStatus build() {
    KernelChaosStatus buildable = new KernelChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
    return buildable;
  }
  
}