package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KernelChaosSpecBuilder extends KernelChaosSpecFluentImpl<KernelChaosSpecBuilder> implements VisitableBuilder<KernelChaosSpec,KernelChaosSpecBuilder>{
  public KernelChaosSpecBuilder() {
    this(false);
  }
  public KernelChaosSpecBuilder(Boolean validationEnabled) {
    this(new KernelChaosSpec(), validationEnabled);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KernelChaosSpec(), validationEnabled);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,KernelChaosSpec instance) {
    this(fluent, instance, false);
  }
  public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,KernelChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDuration(instance.getDuration()); 
    fluent.withFailKernRequest(instance.getFailKernRequest()); 
    fluent.withMode(instance.getMode()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public KernelChaosSpecBuilder(KernelChaosSpec instance) {
    this(instance,false);
  }
  public KernelChaosSpecBuilder(KernelChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDuration(instance.getDuration()); 
    this.withFailKernRequest(instance.getFailKernRequest()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  KernelChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KernelChaosSpec build() {
    KernelChaosSpec buildable = new KernelChaosSpec(fluent.getDuration(),fluent.getFailKernRequest(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getValue());
    return buildable;
  }
  
}