package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JVMChaosSpecFluentImpl<A extends JVMChaosSpecFluent<A>> extends BaseFluent<A> implements JVMChaosSpecFluent<A>{
  public JVMChaosSpecFluentImpl() {
  }
  public JVMChaosSpecFluentImpl(JVMChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withDuration(instance.getDuration()); 
    this.withFlags(instance.getFlags()); 
    this.withMatchers(instance.getMatchers()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withValue(instance.getValue()); 
  }
  private String action;
  private String duration;
  private Map<String,String> flags;
  private Map<String,String> matchers;
  private String mode;
  private SchedulerSpecBuilder scheduler;
  private SelectorSpecBuilder selector;
  private String target;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToFlags(String key,String value) {
    if(this.flags == null && key != null && value != null) { this.flags = new LinkedHashMap(); }
    if(key != null && value != null) {this.flags.put(key, value);} return (A)this;
  }
  public A addToFlags(Map<String,String> map) {
    if(this.flags == null && map != null) { this.flags = new LinkedHashMap(); }
    if(map != null) { this.flags.putAll(map);} return (A)this;
  }
  public A removeFromFlags(String key) {
    if(this.flags == null) { return (A) this; }
    if(key != null && this.flags != null) {this.flags.remove(key);} return (A)this;
  }
  public A removeFromFlags(Map<String,String> map) {
    if(this.flags == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.flags != null){this.flags.remove(key);}}} return (A)this;
  }
  public Map<String,String> getFlags() {
    return this.flags;
  }
  public <K,V>A withFlags(Map<String,String> flags) {
    if (flags == null) { this.flags =  null;} else {this.flags = new LinkedHashMap(flags);} return (A) this;
  }
  public Boolean hasFlags() {
    return this.flags != null;
  }
  public A addToMatchers(String key,String value) {
    if(this.matchers == null && key != null && value != null) { this.matchers = new LinkedHashMap(); }
    if(key != null && value != null) {this.matchers.put(key, value);} return (A)this;
  }
  public A addToMatchers(Map<String,String> map) {
    if(this.matchers == null && map != null) { this.matchers = new LinkedHashMap(); }
    if(map != null) { this.matchers.putAll(map);} return (A)this;
  }
  public A removeFromMatchers(String key) {
    if(this.matchers == null) { return (A) this; }
    if(key != null && this.matchers != null) {this.matchers.remove(key);} return (A)this;
  }
  public A removeFromMatchers(Map<String,String> map) {
    if(this.matchers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.matchers != null){this.matchers.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMatchers() {
    return this.matchers;
  }
  public <K,V>A withMatchers(Map<String,String> matchers) {
    if (matchers == null) { this.matchers =  null;} else {this.matchers = new LinkedHashMap(matchers);} return (A) this;
  }
  public Boolean hasMatchers() {
    return this.matchers != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScheduler instead.
   * @return The buildable object.
   */
  @Deprecated
  public SchedulerSpec getScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public SchedulerSpec buildScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public A withScheduler(SchedulerSpec scheduler) {
    _visitables.get("scheduler").remove(this.scheduler);
    if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} else { this.scheduler = null; _visitables.get("scheduler").remove(this.scheduler); } return (A) this;
  }
  public Boolean hasScheduler() {
    return this.scheduler != null;
  }
  public A withNewScheduler(String cron) {
    return (A)withScheduler(new SchedulerSpec(cron));
  }
  public JVMChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
    return new JVMChaosSpecFluentImpl.SchedulerNestedImpl();
  }
  public JVMChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
    return new JVMChaosSpecFluentImpl.SchedulerNestedImpl(item);
  }
  public JVMChaosSpecFluent.SchedulerNested<A> editScheduler() {
    return withNewSchedulerLike(getScheduler());
  }
  public JVMChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
  }
  public JVMChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public SelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(SelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public JVMChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new JVMChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public JVMChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
    return new JVMChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public JVMChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public JVMChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
  }
  public JVMChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getTarget() {
    return this.target;
  }
  public A withTarget(String target) {
    this.target=target; return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JVMChaosSpecFluentImpl that = (JVMChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (flags != null ? !flags.equals(that.flags) :that.flags != null) return false;
    if (matchers != null ? !matchers.equals(that.matchers) :that.matchers != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (target != null ? !target.equals(that.target) :that.target != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  duration,  flags,  matchers,  mode,  scheduler,  selector,  target,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (flags != null && !flags.isEmpty()) { sb.append("flags:"); sb.append(flags + ","); }
    if (matchers != null && !matchers.isEmpty()) { sb.append("matchers:"); sb.append(matchers + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (scheduler != null) { sb.append("scheduler:"); sb.append(scheduler + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<JVMChaosSpecFluent.SchedulerNested<N>> implements JVMChaosSpecFluent.SchedulerNested<N>,Nested<N>{
    SchedulerNestedImpl(SchedulerSpec item) {
      this.builder = new SchedulerSpecBuilder(this, item);
    }
    SchedulerNestedImpl() {
      this.builder = new SchedulerSpecBuilder(this);
    }
    SchedulerSpecBuilder builder;
    public N and() {
      return (N) JVMChaosSpecFluentImpl.this.withScheduler(builder.build());
    }
    public N endScheduler() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<JVMChaosSpecFluent.SelectorNested<N>> implements JVMChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(SelectorSpec item) {
      this.builder = new SelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new SelectorSpecBuilder(this);
    }
    SelectorSpecBuilder builder;
    public N and() {
      return (N) JVMChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}