package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JVMChaosSpecBuilder extends JVMChaosSpecFluentImpl<JVMChaosSpecBuilder> implements VisitableBuilder<JVMChaosSpec,JVMChaosSpecBuilder>{
  public JVMChaosSpecBuilder() {
    this(false);
  }
  public JVMChaosSpecBuilder(Boolean validationEnabled) {
    this(new JVMChaosSpec(), validationEnabled);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JVMChaosSpec(), validationEnabled);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,JVMChaosSpec instance) {
    this(fluent, instance, false);
  }
  public JVMChaosSpecBuilder(JVMChaosSpecFluent<?> fluent,JVMChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withFlags(instance.getFlags()); 
    fluent.withMatchers(instance.getMatchers()); 
    fluent.withMode(instance.getMode()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  public JVMChaosSpecBuilder(JVMChaosSpec instance) {
    this(instance,false);
  }
  public JVMChaosSpecBuilder(JVMChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withDuration(instance.getDuration()); 
    this.withFlags(instance.getFlags()); 
    this.withMatchers(instance.getMatchers()); 
    this.withMode(instance.getMode()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withTarget(instance.getTarget()); 
    this.withValue(instance.getValue()); 
    this.validationEnabled = validationEnabled; 
  }
  JVMChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JVMChaosSpec build() {
    JVMChaosSpec buildable = new JVMChaosSpec(fluent.getAction(),fluent.getDuration(),fluent.getFlags(),fluent.getMatchers(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getTarget(),fluent.getValue());
    return buildable;
  }
  
}