package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IoChaosStatusBuilder extends IoChaosStatusFluentImpl<IoChaosStatusBuilder> implements VisitableBuilder<IoChaosStatus,IoChaosStatusBuilder>{
  public IoChaosStatusBuilder() {
    this(false);
  }
  public IoChaosStatusBuilder(Boolean validationEnabled) {
    this(new IoChaosStatus(), validationEnabled);
  }
  public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IoChaosStatus(), validationEnabled);
  }
  public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent,IoChaosStatus instance) {
    this(fluent, instance, false);
  }
  public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent,IoChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  public IoChaosStatusBuilder(IoChaosStatus instance) {
    this(instance,false);
  }
  public IoChaosStatusBuilder(IoChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExperiment(instance.getExperiment()); 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  IoChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IoChaosStatus build() {
    IoChaosStatus buildable = new IoChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
    return buildable;
  }
  
}