package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IoChaosSpecBuilder extends IoChaosSpecFluentImpl<IoChaosSpecBuilder> implements VisitableBuilder<IoChaosSpec,IoChaosSpecBuilder>{
  public IoChaosSpecBuilder() {
    this(false);
  }
  public IoChaosSpecBuilder(Boolean validationEnabled) {
    this(new IoChaosSpec(), validationEnabled);
  }
  public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IoChaosSpec(), validationEnabled);
  }
  public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent,IoChaosSpec instance) {
    this(fluent, instance, false);
  }
  public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent,IoChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withAttr(instance.getAttr()); 
    fluent.withContainerName(instance.getContainerName()); 
    fluent.withDelay(instance.getDelay()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withErrno(instance.getErrno()); 
    fluent.withMethods(instance.getMethods()); 
    fluent.withMistake(instance.getMistake()); 
    fluent.withMode(instance.getMode()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPercent(instance.getPercent()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withValue(instance.getValue()); 
    fluent.withVolumePath(instance.getVolumePath()); 
    this.validationEnabled = validationEnabled; 
  }
  public IoChaosSpecBuilder(IoChaosSpec instance) {
    this(instance,false);
  }
  public IoChaosSpecBuilder(IoChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withAttr(instance.getAttr()); 
    this.withContainerName(instance.getContainerName()); 
    this.withDelay(instance.getDelay()); 
    this.withDuration(instance.getDuration()); 
    this.withErrno(instance.getErrno()); 
    this.withMethods(instance.getMethods()); 
    this.withMistake(instance.getMistake()); 
    this.withMode(instance.getMode()); 
    this.withPath(instance.getPath()); 
    this.withPercent(instance.getPercent()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
    this.withVolumePath(instance.getVolumePath()); 
    this.validationEnabled = validationEnabled; 
  }
  IoChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IoChaosSpec build() {
    IoChaosSpec buildable = new IoChaosSpec(fluent.getAction(),fluent.getAttr(),fluent.getContainerName(),fluent.getDelay(),fluent.getDuration(),fluent.getErrno(),fluent.getMethods(),fluent.getMistake(),fluent.getMode(),fluent.getPath(),fluent.getPercent(),fluent.getScheduler(),fluent.getSelector(),fluent.getValue(),fluent.getVolumePath());
    return buildable;
  }
  
}