package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IoChaosListBuilder extends IoChaosListFluentImpl<IoChaosListBuilder> implements VisitableBuilder<IoChaosList,IoChaosListBuilder>{
  public IoChaosListBuilder() {
    this(false);
  }
  public IoChaosListBuilder(Boolean validationEnabled) {
    this(new IoChaosList(), validationEnabled);
  }
  public IoChaosListBuilder(IoChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public IoChaosListBuilder(IoChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IoChaosList(), validationEnabled);
  }
  public IoChaosListBuilder(IoChaosListFluent<?> fluent,IoChaosList instance) {
    this(fluent, instance, false);
  }
  public IoChaosListBuilder(IoChaosListFluent<?> fluent,IoChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public IoChaosListBuilder(IoChaosList instance) {
    this(instance,false);
  }
  public IoChaosListBuilder(IoChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  IoChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public IoChaosList build() {
    IoChaosList buildable = new IoChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}