package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IoChaosBuilder extends IoChaosFluentImpl<IoChaosBuilder> implements VisitableBuilder<IoChaos,IoChaosBuilder>{
  public IoChaosBuilder() {
    this(false);
  }
  public IoChaosBuilder(Boolean validationEnabled) {
    this(new IoChaos(), validationEnabled);
  }
  public IoChaosBuilder(IoChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public IoChaosBuilder(IoChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IoChaos(), validationEnabled);
  }
  public IoChaosBuilder(IoChaosFluent<?> fluent,IoChaos instance) {
    this(fluent, instance, false);
  }
  public IoChaosBuilder(IoChaosFluent<?> fluent,IoChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public IoChaosBuilder(IoChaos instance) {
    this(instance,false);
  }
  public IoChaosBuilder(IoChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  IoChaosFluent<?> fluent;
  Boolean validationEnabled;
  public IoChaos build() {
    IoChaos buildable = new IoChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}