package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPChaosSpecFluentImpl<A extends HTTPChaosSpecFluent<A>> extends BaseFluent<A> implements HTTPChaosSpecFluent<A>{
  public HTTPChaosSpecFluentImpl() {
  }
  public HTTPChaosSpecFluentImpl(HTTPChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withDuration(instance.getDuration()); 
    this.withHeaders(instance.getHeaders()); 
    this.withMode(instance.getMode()); 
    this.withPercent(instance.getPercent()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
  }
  private String action;
  private String duration;
  private ArrayList<MatcherBuilder> headers = new ArrayList<MatcherBuilder>();
  private String mode;
  private String percent;
  private SchedulerSpecBuilder scheduler;
  private SelectorSpecBuilder selector;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToHeaders(Integer index,Matcher item) {
    if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").add(index >= 0 ? index : _visitables.get("headers").size(), builder);this.headers.add(index >= 0 ? index : headers.size(), builder); return (A)this;
  }
  public A setToHeaders(Integer index,Matcher item) {
    if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
    MatcherBuilder builder = new MatcherBuilder(item);
    if (index < 0 || index >= _visitables.get("headers").size()) { _visitables.get("headers").add(builder); } else { _visitables.get("headers").set(index, builder);}
    if (index < 0 || index >= headers.size()) { headers.add(builder); } else { headers.set(index, builder);}
     return (A)this;
  }
  public A addToHeaders(io.fabric8.chaosmesh.v1alpha1.Matcher... items) {
    if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A addAllToHeaders(Collection<Matcher> items) {
    if (this.headers == null) {this.headers = new ArrayList<MatcherBuilder>();}
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
  }
  public A removeFromHeaders(io.fabric8.chaosmesh.v1alpha1.Matcher... items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
  }
  public A removeAllFromHeaders(Collection<Matcher> items) {
    for (Matcher item : items) {MatcherBuilder builder = new MatcherBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHeaders(Predicate<MatcherBuilder> predicate) {
    if (headers == null) return (A) this;
    final Iterator<MatcherBuilder> each = headers.iterator();
    final List visitables = _visitables.get("headers");
    while (each.hasNext()) {
      MatcherBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Matcher> getHeaders() {
    return headers != null ? build(headers) : null;
  }
  public List<Matcher> buildHeaders() {
    return headers != null ? build(headers) : null;
  }
  public Matcher buildHeader(Integer index) {
    return this.headers.get(index).build();
  }
  public Matcher buildFirstHeader() {
    return this.headers.get(0).build();
  }
  public Matcher buildLastHeader() {
    return this.headers.get(headers.size() - 1).build();
  }
  public Matcher buildMatchingHeader(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHeader(Predicate<MatcherBuilder> predicate) {
    for (MatcherBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHeaders(List<Matcher> headers) {
    if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
    if (headers != null) {this.headers = new ArrayList(); for (Matcher item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
  }
  public A withHeaders(io.fabric8.chaosmesh.v1alpha1.Matcher... headers) {
    if (this.headers != null) {this.headers.clear();}
    if (headers != null) {for (Matcher item :headers){ this.addToHeaders(item);}} return (A) this;
  }
  public Boolean hasHeaders() {
    return headers != null && !headers.isEmpty();
  }
  public HTTPChaosSpecFluent.HeadersNested<A> addNewHeader() {
    return new HTTPChaosSpecFluentImpl.HeadersNestedImpl();
  }
  public HTTPChaosSpecFluent.HeadersNested<A> addNewHeaderLike(Matcher item) {
    return new HTTPChaosSpecFluentImpl.HeadersNestedImpl(-1, item);
  }
  public HTTPChaosSpecFluent.HeadersNested<A> setNewHeaderLike(Integer index,Matcher item) {
    return new HTTPChaosSpecFluentImpl.HeadersNestedImpl(index, item);
  }
  public HTTPChaosSpecFluent.HeadersNested<A> editHeader(Integer index) {
    if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public HTTPChaosSpecFluent.HeadersNested<A> editFirstHeader() {
    if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
    return setNewHeaderLike(0, buildHeader(0));
  }
  public HTTPChaosSpecFluent.HeadersNested<A> editLastHeader() {
    int index = headers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public HTTPChaosSpecFluent.HeadersNested<A> editMatchingHeader(Predicate<MatcherBuilder> predicate) {
    int index = -1;
    for (int i=0;i<headers.size();i++) { 
    if (predicate.test(headers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  public String getPercent() {
    return this.percent;
  }
  public A withPercent(String percent) {
    this.percent=percent; return (A) this;
  }
  public Boolean hasPercent() {
    return this.percent != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScheduler instead.
   * @return The buildable object.
   */
  @Deprecated
  public SchedulerSpec getScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public SchedulerSpec buildScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public A withScheduler(SchedulerSpec scheduler) {
    _visitables.get("scheduler").remove(this.scheduler);
    if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} else { this.scheduler = null; _visitables.get("scheduler").remove(this.scheduler); } return (A) this;
  }
  public Boolean hasScheduler() {
    return this.scheduler != null;
  }
  public A withNewScheduler(String cron) {
    return (A)withScheduler(new SchedulerSpec(cron));
  }
  public HTTPChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
    return new HTTPChaosSpecFluentImpl.SchedulerNestedImpl();
  }
  public HTTPChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
    return new HTTPChaosSpecFluentImpl.SchedulerNestedImpl(item);
  }
  public HTTPChaosSpecFluent.SchedulerNested<A> editScheduler() {
    return withNewSchedulerLike(getScheduler());
  }
  public HTTPChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
  }
  public HTTPChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public SelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(SelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public HTTPChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new HTTPChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public HTTPChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
    return new HTTPChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public HTTPChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
  }
  public HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPChaosSpecFluentImpl that = (HTTPChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
    if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  duration,  headers,  mode,  percent,  scheduler,  selector,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (scheduler != null) { sb.append("scheduler:"); sb.append(scheduler + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class HeadersNestedImpl<N> extends MatcherFluentImpl<HTTPChaosSpecFluent.HeadersNested<N>> implements HTTPChaosSpecFluent.HeadersNested<N>,Nested<N>{
    HeadersNestedImpl(Integer index,Matcher item) {
      this.index = index;
      this.builder = new MatcherBuilder(this, item);
    }
    HeadersNestedImpl() {
      this.index = -1;
      this.builder = new MatcherBuilder(this);
    }
    MatcherBuilder builder;
    Integer index;
    public N and() {
      return (N) HTTPChaosSpecFluentImpl.this.setToHeaders(index,builder.build());
    }
    public N endHeader() {
      return and();
    }
    
  }
  class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<HTTPChaosSpecFluent.SchedulerNested<N>> implements HTTPChaosSpecFluent.SchedulerNested<N>,Nested<N>{
    SchedulerNestedImpl(SchedulerSpec item) {
      this.builder = new SchedulerSpecBuilder(this, item);
    }
    SchedulerNestedImpl() {
      this.builder = new SchedulerSpecBuilder(this);
    }
    SchedulerSpecBuilder builder;
    public N and() {
      return (N) HTTPChaosSpecFluentImpl.this.withScheduler(builder.build());
    }
    public N endScheduler() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<HTTPChaosSpecFluent.SelectorNested<N>> implements HTTPChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(SelectorSpec item) {
      this.builder = new SelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new SelectorSpecBuilder(this);
    }
    SelectorSpecBuilder builder;
    public N and() {
      return (N) HTTPChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}