package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExperimentStatusBuilder extends ExperimentStatusFluentImpl<ExperimentStatusBuilder> implements VisitableBuilder<ExperimentStatus,ExperimentStatusBuilder>{
  public ExperimentStatusBuilder() {
    this(false);
  }
  public ExperimentStatusBuilder(Boolean validationEnabled) {
    this(new ExperimentStatus(), validationEnabled);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExperimentStatus(), validationEnabled);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,ExperimentStatus instance) {
    this(fluent, instance, false);
  }
  public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,ExperimentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDuration(instance.getDuration()); 
    fluent.withEndTime(instance.getEndTime()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withPodRecords(instance.getPodRecords()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStartTime(instance.getStartTime()); 
    this.validationEnabled = validationEnabled; 
  }
  public ExperimentStatusBuilder(ExperimentStatus instance) {
    this(instance,false);
  }
  public ExperimentStatusBuilder(ExperimentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDuration(instance.getDuration()); 
    this.withEndTime(instance.getEndTime()); 
    this.withPhase(instance.getPhase()); 
    this.withPodRecords(instance.getPodRecords()); 
    this.withReason(instance.getReason()); 
    this.withStartTime(instance.getStartTime()); 
    this.validationEnabled = validationEnabled; 
  }
  ExperimentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ExperimentStatus build() {
    ExperimentStatus buildable = new ExperimentStatus(fluent.getDuration(),fluent.getEndTime(),fluent.getPhase(),fluent.getPodRecords(),fluent.getReason(),fluent.getStartTime());
    return buildable;
  }
  
}