package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSChaosStatusBuilder extends DNSChaosStatusFluentImpl<DNSChaosStatusBuilder> implements VisitableBuilder<DNSChaosStatus,DNSChaosStatusBuilder>{
  public DNSChaosStatusBuilder() {
    this(false);
  }
  public DNSChaosStatusBuilder(Boolean validationEnabled) {
    this(new DNSChaosStatus(), validationEnabled);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSChaosStatus(), validationEnabled);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,DNSChaosStatus instance) {
    this(fluent, instance, false);
  }
  public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,DNSChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  public DNSChaosStatusBuilder(DNSChaosStatus instance) {
    this(instance,false);
  }
  public DNSChaosStatusBuilder(DNSChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExperiment(instance.getExperiment()); 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  DNSChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DNSChaosStatus build() {
    DNSChaosStatus buildable = new DNSChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
    return buildable;
  }
  
}