package io.fabric8.chaosmesh.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DNSChaosSpecFluentImpl<A extends DNSChaosSpecFluent<A>> extends BaseFluent<A> implements DNSChaosSpecFluent<A>{
  public DNSChaosSpecFluentImpl() {
  }
  public DNSChaosSpecFluentImpl(DNSChaosSpec instance) {
    this.withAction(instance.getAction()); 
    this.withDuration(instance.getDuration()); 
    this.withMode(instance.getMode()); 
    this.withPatterns(instance.getPatterns()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSelector(instance.getSelector()); 
    this.withValue(instance.getValue()); 
  }
  private String action;
  private String duration;
  private String mode;
  private List<String> patterns = new ArrayList<String>();
  private SchedulerSpecBuilder scheduler;
  private SelectorSpecBuilder selector;
  private String value;
  public String getAction() {
    return this.action;
  }
  public A withAction(String action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public String getDuration() {
    return this.duration;
  }
  public A withDuration(String duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public String getMode() {
    return this.mode;
  }
  public A withMode(String mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  public A addToPatterns(Integer index,String item) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    this.patterns.add(index, item);
    return (A)this;
  }
  public A setToPatterns(Integer index,String item) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    this.patterns.set(index, item); return (A)this;
  }
  public A addToPatterns(java.lang.String... items) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    for (String item : items) {this.patterns.add(item);} return (A)this;
  }
  public A addAllToPatterns(Collection<String> items) {
    if (this.patterns == null) {this.patterns = new ArrayList<String>();}
    for (String item : items) {this.patterns.add(item);} return (A)this;
  }
  public A removeFromPatterns(java.lang.String... items) {
    for (String item : items) {if (this.patterns!= null){ this.patterns.remove(item);}} return (A)this;
  }
  public A removeAllFromPatterns(Collection<String> items) {
    for (String item : items) {if (this.patterns!= null){ this.patterns.remove(item);}} return (A)this;
  }
  public List<String> getPatterns() {
    return this.patterns;
  }
  public String getPattern(Integer index) {
    return this.patterns.get(index);
  }
  public String getFirstPattern() {
    return this.patterns.get(0);
  }
  public String getLastPattern() {
    return this.patterns.get(patterns.size() - 1);
  }
  public String getMatchingPattern(Predicate<String> predicate) {
    for (String item: patterns) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPattern(Predicate<String> predicate) {
    for (String item: patterns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPatterns(List<String> patterns) {
    if (patterns != null) {this.patterns = new ArrayList(); for (String item : patterns){this.addToPatterns(item);}} else { this.patterns = null;} return (A) this;
  }
  public A withPatterns(java.lang.String... patterns) {
    if (this.patterns != null) {this.patterns.clear();}
    if (patterns != null) {for (String item :patterns){ this.addToPatterns(item);}} return (A) this;
  }
  public Boolean hasPatterns() {
    return patterns != null && !patterns.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildScheduler instead.
   * @return The buildable object.
   */
  @Deprecated
  public SchedulerSpec getScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public SchedulerSpec buildScheduler() {
    return this.scheduler!=null ?this.scheduler.build():null;
  }
  public A withScheduler(SchedulerSpec scheduler) {
    _visitables.get("scheduler").remove(this.scheduler);
    if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} else { this.scheduler = null; _visitables.get("scheduler").remove(this.scheduler); } return (A) this;
  }
  public Boolean hasScheduler() {
    return this.scheduler != null;
  }
  public A withNewScheduler(String cron) {
    return (A)withScheduler(new SchedulerSpec(cron));
  }
  public DNSChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
    return new DNSChaosSpecFluentImpl.SchedulerNestedImpl();
  }
  public DNSChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
    return new DNSChaosSpecFluentImpl.SchedulerNestedImpl(item);
  }
  public DNSChaosSpecFluent.SchedulerNested<A> editScheduler() {
    return withNewSchedulerLike(getScheduler());
  }
  public DNSChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
  }
  public DNSChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
    return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public SelectorSpec getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public SelectorSpec buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(SelectorSpec selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public DNSChaosSpecFluent.SelectorNested<A> withNewSelector() {
    return new DNSChaosSpecFluentImpl.SelectorNestedImpl();
  }
  public DNSChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
    return new DNSChaosSpecFluentImpl.SelectorNestedImpl(item);
  }
  public DNSChaosSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public DNSChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
  }
  public DNSChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public Boolean hasValue() {
    return this.value != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DNSChaosSpecFluentImpl that = (DNSChaosSpecFluentImpl) o;
    if (action != null ? !action.equals(that.action) :that.action != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
    if (patterns != null ? !patterns.equals(that.patterns) :that.patterns != null) return false;
    if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(action,  duration,  mode,  patterns,  scheduler,  selector,  value,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (patterns != null && !patterns.isEmpty()) { sb.append("patterns:"); sb.append(patterns + ","); }
    if (scheduler != null) { sb.append("scheduler:"); sb.append(scheduler + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (value != null) { sb.append("value:"); sb.append(value); }
    sb.append("}");
    return sb.toString();
  }
  class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<DNSChaosSpecFluent.SchedulerNested<N>> implements DNSChaosSpecFluent.SchedulerNested<N>,Nested<N>{
    SchedulerNestedImpl(SchedulerSpec item) {
      this.builder = new SchedulerSpecBuilder(this, item);
    }
    SchedulerNestedImpl() {
      this.builder = new SchedulerSpecBuilder(this);
    }
    SchedulerSpecBuilder builder;
    public N and() {
      return (N) DNSChaosSpecFluentImpl.this.withScheduler(builder.build());
    }
    public N endScheduler() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<DNSChaosSpecFluent.SelectorNested<N>> implements DNSChaosSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(SelectorSpec item) {
      this.builder = new SelectorSpecBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new SelectorSpecBuilder(this);
    }
    SelectorSpecBuilder builder;
    public N and() {
      return (N) DNSChaosSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}