package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsChaosStatusBuilder extends AwsChaosStatusFluentImpl<AwsChaosStatusBuilder> implements VisitableBuilder<AwsChaosStatus,AwsChaosStatusBuilder>{
  public AwsChaosStatusBuilder() {
    this(false);
  }
  public AwsChaosStatusBuilder(Boolean validationEnabled) {
    this(new AwsChaosStatus(), validationEnabled);
  }
  public AwsChaosStatusBuilder(AwsChaosStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsChaosStatusBuilder(AwsChaosStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsChaosStatus(), validationEnabled);
  }
  public AwsChaosStatusBuilder(AwsChaosStatusFluent<?> fluent,AwsChaosStatus instance) {
    this(fluent, instance, false);
  }
  public AwsChaosStatusBuilder(AwsChaosStatusFluent<?> fluent,AwsChaosStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExperiment(instance.getExperiment()); 
    fluent.withFailedMessage(instance.getFailedMessage()); 
    fluent.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  public AwsChaosStatusBuilder(AwsChaosStatus instance) {
    this(instance,false);
  }
  public AwsChaosStatusBuilder(AwsChaosStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExperiment(instance.getExperiment()); 
    this.withFailedMessage(instance.getFailedMessage()); 
    this.withScheduler(instance.getScheduler()); 
    this.validationEnabled = validationEnabled; 
  }
  AwsChaosStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AwsChaosStatus build() {
    AwsChaosStatus buildable = new AwsChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
    return buildable;
  }
  
}