package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsChaosSpecBuilder extends AwsChaosSpecFluentImpl<AwsChaosSpecBuilder> implements VisitableBuilder<AwsChaosSpec,AwsChaosSpecBuilder>{
  public AwsChaosSpecBuilder() {
    this(false);
  }
  public AwsChaosSpecBuilder(Boolean validationEnabled) {
    this(new AwsChaosSpec(), validationEnabled);
  }
  public AwsChaosSpecBuilder(AwsChaosSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsChaosSpecBuilder(AwsChaosSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsChaosSpec(), validationEnabled);
  }
  public AwsChaosSpecBuilder(AwsChaosSpecFluent<?> fluent,AwsChaosSpec instance) {
    this(fluent, instance, false);
  }
  public AwsChaosSpecBuilder(AwsChaosSpecFluent<?> fluent,AwsChaosSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAction(instance.getAction()); 
    fluent.withAwsRegion(instance.getAwsRegion()); 
    fluent.withDeviceName(instance.getDeviceName()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withEc2Instance(instance.getEc2Instance()); 
    fluent.withEndpoint(instance.getEndpoint()); 
    fluent.withScheduler(instance.getScheduler()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withVolumeID(instance.getVolumeID()); 
    this.validationEnabled = validationEnabled; 
  }
  public AwsChaosSpecBuilder(AwsChaosSpec instance) {
    this(instance,false);
  }
  public AwsChaosSpecBuilder(AwsChaosSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAction(instance.getAction()); 
    this.withAwsRegion(instance.getAwsRegion()); 
    this.withDeviceName(instance.getDeviceName()); 
    this.withDuration(instance.getDuration()); 
    this.withEc2Instance(instance.getEc2Instance()); 
    this.withEndpoint(instance.getEndpoint()); 
    this.withScheduler(instance.getScheduler()); 
    this.withSecretName(instance.getSecretName()); 
    this.withVolumeID(instance.getVolumeID()); 
    this.validationEnabled = validationEnabled; 
  }
  AwsChaosSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AwsChaosSpec build() {
    AwsChaosSpec buildable = new AwsChaosSpec(fluent.getAction(),fluent.getAwsRegion(),fluent.getDeviceName(),fluent.getDuration(),fluent.getEc2Instance(),fluent.getEndpoint(),fluent.getScheduler(),fluent.getSecretName(),fluent.getVolumeID());
    return buildable;
  }
  
}