package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsChaosListBuilder extends AwsChaosListFluentImpl<AwsChaosListBuilder> implements VisitableBuilder<AwsChaosList,AwsChaosListBuilder>{
  public AwsChaosListBuilder() {
    this(false);
  }
  public AwsChaosListBuilder(Boolean validationEnabled) {
    this(new AwsChaosList(), validationEnabled);
  }
  public AwsChaosListBuilder(AwsChaosListFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsChaosListBuilder(AwsChaosListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsChaosList(), validationEnabled);
  }
  public AwsChaosListBuilder(AwsChaosListFluent<?> fluent,AwsChaosList instance) {
    this(fluent, instance, false);
  }
  public AwsChaosListBuilder(AwsChaosListFluent<?> fluent,AwsChaosList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public AwsChaosListBuilder(AwsChaosList instance) {
    this(instance,false);
  }
  public AwsChaosListBuilder(AwsChaosList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  AwsChaosListFluent<?> fluent;
  Boolean validationEnabled;
  public AwsChaosList build() {
    AwsChaosList buildable = new AwsChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}