package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AwsChaosBuilder extends AwsChaosFluentImpl<AwsChaosBuilder> implements VisitableBuilder<AwsChaos,AwsChaosBuilder>{
  public AwsChaosBuilder() {
    this(false);
  }
  public AwsChaosBuilder(Boolean validationEnabled) {
    this(new AwsChaos(), validationEnabled);
  }
  public AwsChaosBuilder(AwsChaosFluent<?> fluent) {
    this(fluent, false);
  }
  public AwsChaosBuilder(AwsChaosFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AwsChaos(), validationEnabled);
  }
  public AwsChaosBuilder(AwsChaosFluent<?> fluent,AwsChaos instance) {
    this(fluent, instance, false);
  }
  public AwsChaosBuilder(AwsChaosFluent<?> fluent,AwsChaos instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public AwsChaosBuilder(AwsChaos instance) {
    this(instance,false);
  }
  public AwsChaosBuilder(AwsChaos instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  AwsChaosFluent<?> fluent;
  Boolean validationEnabled;
  public AwsChaos build() {
    AwsChaos buildable = new AwsChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}