package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class PodNetworkChaosSpecFluentImpl<A extends io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent<A> {

    private java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder> ipsets;
    private java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder> iptables;
    private java.util.List<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder> tcs;

    public PodNetworkChaosSpecFluentImpl() {
    }

    public PodNetworkChaosSpecFluentImpl(io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpec instance) {
        this.withIpsets(instance.getIpsets()); 
        this.withIptables(instance.getIptables()); 
        this.withTcs(instance.getTcs()); 
    }

    public A addToIpsets(int index,io.fabric8.chaosmesh.v1alpha1.RawIPSet item) {
        if (this.ipsets == null) {this.ipsets = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(item);_visitables.get("ipsets").add(index >= 0 ? index : _visitables.get("ipsets").size(), builder);this.ipsets.add(index >= 0 ? index : ipsets.size(), builder); return (A)this;
    }

    public A setToIpsets(int index,io.fabric8.chaosmesh.v1alpha1.RawIPSet item) {
        if (this.ipsets == null) {this.ipsets = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(item);
        if (index < 0 || index >= _visitables.get("ipsets").size()) { _visitables.get("ipsets").add(builder); } else { _visitables.get("ipsets").set(index, builder);}
        if (index < 0 || index >= ipsets.size()) { ipsets.add(builder); } else { ipsets.set(index, builder);}
         return (A)this;
    }

    public A addToIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... items) {
        if (this.ipsets == null) {this.ipsets = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.RawIPSet item : items) {io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
    }

    public A addAllToIpsets(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.RawIPSet> items) {
        if (this.ipsets == null) {this.ipsets = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.RawIPSet item : items) {io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
    }

    public A removeFromIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... items) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIPSet item : items) {io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder);if (this.ipsets != null) {this.ipsets.remove(builder);}} return (A)this;
    }

    public A removeAllFromIpsets(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.RawIPSet> items) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIPSet item : items) {io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder);if (this.ipsets != null) {this.ipsets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIpsets(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder> predicate) {
        if (ipsets == null) return (A) this;
        final Iterator<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder> each = ipsets.iterator();
        final List visitables = _visitables.get("ipsets");
        while (each.hasNext()) {
          io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildIpsets instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIPSet> getIpsets() {
        return build(ipsets);
    }

    public java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIPSet> buildIpsets() {
        return build(ipsets);
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIPSet buildIpset(int index) {
        return this.ipsets.get(index).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIPSet buildFirstIpset() {
        return this.ipsets.get(0).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIPSet buildLastIpset() {
        return this.ipsets.get(ipsets.size() - 1).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIPSet buildMatchingIpset(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder item: ipsets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingIpset(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder item: ipsets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpsets(java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIPSet> ipsets) {
        if (this.ipsets != null) { _visitables.get("ipsets").removeAll(this.ipsets);}
        if (ipsets != null) {this.ipsets = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder>(); for (io.fabric8.chaosmesh.v1alpha1.RawIPSet item : ipsets){this.addToIpsets(item);}} else { this.ipsets = null;} return (A) this;
    }

    public A withIpsets(io.fabric8.chaosmesh.v1alpha1.RawIPSet... ipsets) {
        if (this.ipsets != null) {this.ipsets.clear();}
        if (ipsets != null) {for (io.fabric8.chaosmesh.v1alpha1.RawIPSet item :ipsets){ this.addToIpsets(item);}} return (A) this;
    }

    public java.lang.Boolean hasIpsets() {
        return ipsets != null && !ipsets.isEmpty();
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpset() {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.IpsetsNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpsetLike(io.fabric8.chaosmesh.v1alpha1.RawIPSet item) {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.IpsetsNestedImpl(-1, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> setNewIpsetLike(int index,io.fabric8.chaosmesh.v1alpha1.RawIPSet item) {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.IpsetsNestedImpl(index, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> editIpset(int index) {
        if (ipsets.size() <= index) throw new RuntimeException("Can't edit ipsets. Index exceeds size.");
        return setNewIpsetLike(index, buildIpset(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> editFirstIpset() {
        if (ipsets.size() == 0) throw new RuntimeException("Can't edit first ipsets. The list is empty.");
        return setNewIpsetLike(0, buildIpset(0));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> editLastIpset() {
        int index = ipsets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ipsets. The list is empty.");
        return setNewIpsetLike(index, buildIpset(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<A> editMatchingIpset(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ipsets.size();i++) { 
        if (predicate.test(ipsets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ipsets. No match found.");
        return setNewIpsetLike(index, buildIpset(index));
    }

    public A addToIptables(int index,io.fabric8.chaosmesh.v1alpha1.RawIptables item) {
        if (this.iptables == null) {this.iptables = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(item);_visitables.get("iptables").add(index >= 0 ? index : _visitables.get("iptables").size(), builder);this.iptables.add(index >= 0 ? index : iptables.size(), builder); return (A)this;
    }

    public A setToIptables(int index,io.fabric8.chaosmesh.v1alpha1.RawIptables item) {
        if (this.iptables == null) {this.iptables = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(item);
        if (index < 0 || index >= _visitables.get("iptables").size()) { _visitables.get("iptables").add(builder); } else { _visitables.get("iptables").set(index, builder);}
        if (index < 0 || index >= iptables.size()) { iptables.add(builder); } else { iptables.set(index, builder);}
         return (A)this;
    }

    public A addToIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... items) {
        if (this.iptables == null) {this.iptables = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.RawIptables item : items) {io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
    }

    public A addAllToIptables(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.RawIptables> items) {
        if (this.iptables == null) {this.iptables = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.RawIptables item : items) {io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
    }

    public A removeFromIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... items) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIptables item : items) {io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(item);_visitables.get("iptables").remove(builder);if (this.iptables != null) {this.iptables.remove(builder);}} return (A)this;
    }

    public A removeAllFromIptables(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.RawIptables> items) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIptables item : items) {io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(item);_visitables.get("iptables").remove(builder);if (this.iptables != null) {this.iptables.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIptables(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder> predicate) {
        if (iptables == null) return (A) this;
        final Iterator<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder> each = iptables.iterator();
        final List visitables = _visitables.get("iptables");
        while (each.hasNext()) {
          io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildIptables instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIptables> getIptables() {
        return build(iptables);
    }

    public java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIptables> buildIptables() {
        return build(iptables);
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIptables buildIptable(int index) {
        return this.iptables.get(index).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIptables buildFirstIptable() {
        return this.iptables.get(0).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIptables buildLastIptable() {
        return this.iptables.get(iptables.size() - 1).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawIptables buildMatchingIptable(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder item: iptables) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingIptable(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder item: iptables) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIptables(java.util.List<io.fabric8.chaosmesh.v1alpha1.RawIptables> iptables) {
        if (this.iptables != null) { _visitables.get("iptables").removeAll(this.iptables);}
        if (iptables != null) {this.iptables = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder>(); for (io.fabric8.chaosmesh.v1alpha1.RawIptables item : iptables){this.addToIptables(item);}} else { this.iptables = null;} return (A) this;
    }

    public A withIptables(io.fabric8.chaosmesh.v1alpha1.RawIptables... iptables) {
        if (this.iptables != null) {this.iptables.clear();}
        if (iptables != null) {for (io.fabric8.chaosmesh.v1alpha1.RawIptables item :iptables){ this.addToIptables(item);}} return (A) this;
    }

    public java.lang.Boolean hasIptables() {
        return iptables != null && !iptables.isEmpty();
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptable() {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.IptablesNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptableLike(io.fabric8.chaosmesh.v1alpha1.RawIptables item) {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.IptablesNestedImpl(-1, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> setNewIptableLike(int index,io.fabric8.chaosmesh.v1alpha1.RawIptables item) {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.IptablesNestedImpl(index, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> editIptable(int index) {
        if (iptables.size() <= index) throw new RuntimeException("Can't edit iptables. Index exceeds size.");
        return setNewIptableLike(index, buildIptable(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> editFirstIptable() {
        if (iptables.size() == 0) throw new RuntimeException("Can't edit first iptables. The list is empty.");
        return setNewIptableLike(0, buildIptable(0));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> editLastIptable() {
        int index = iptables.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last iptables. The list is empty.");
        return setNewIptableLike(index, buildIptable(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<A> editMatchingIptable(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<iptables.size();i++) { 
        if (predicate.test(iptables.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching iptables. No match found.");
        return setNewIptableLike(index, buildIptable(index));
    }

    public A addToTcs(int index,io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item) {
        if (this.tcs == null) {this.tcs = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(item);_visitables.get("tcs").add(index >= 0 ? index : _visitables.get("tcs").size(), builder);this.tcs.add(index >= 0 ? index : tcs.size(), builder); return (A)this;
    }

    public A setToTcs(int index,io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item) {
        if (this.tcs == null) {this.tcs = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(item);
        if (index < 0 || index >= _visitables.get("tcs").size()) { _visitables.get("tcs").add(builder); } else { _visitables.get("tcs").set(index, builder);}
        if (index < 0 || index >= tcs.size()) { tcs.add(builder); } else { tcs.set(index, builder);}
         return (A)this;
    }

    public A addToTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... items) {
        if (this.tcs == null) {this.tcs = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item : items) {io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
    }

    public A addAllToTcs(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.RawTrafficControl> items) {
        if (this.tcs == null) {this.tcs = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item : items) {io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
    }

    public A removeFromTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... items) {
        for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item : items) {io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder);if (this.tcs != null) {this.tcs.remove(builder);}} return (A)this;
    }

    public A removeAllFromTcs(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.RawTrafficControl> items) {
        for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item : items) {io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder);if (this.tcs != null) {this.tcs.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTcs(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder> predicate) {
        if (tcs == null) return (A) this;
        final Iterator<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder> each = tcs.iterator();
        final List visitables = _visitables.get("tcs");
        while (each.hasNext()) {
          io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTcs instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.chaosmesh.v1alpha1.RawTrafficControl> getTcs() {
        return build(tcs);
    }

    public java.util.List<io.fabric8.chaosmesh.v1alpha1.RawTrafficControl> buildTcs() {
        return build(tcs);
    }

    public io.fabric8.chaosmesh.v1alpha1.RawTrafficControl buildTc(int index) {
        return this.tcs.get(index).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawTrafficControl buildFirstTc() {
        return this.tcs.get(0).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawTrafficControl buildLastTc() {
        return this.tcs.get(tcs.size() - 1).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.RawTrafficControl buildMatchingTc(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder item: tcs) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingTc(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder item: tcs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTcs(java.util.List<io.fabric8.chaosmesh.v1alpha1.RawTrafficControl> tcs) {
        if (this.tcs != null) { _visitables.get("tcs").removeAll(this.tcs);}
        if (tcs != null) {this.tcs = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder>(); for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item : tcs){this.addToTcs(item);}} else { this.tcs = null;} return (A) this;
    }

    public A withTcs(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl... tcs) {
        if (this.tcs != null) {this.tcs.clear();}
        if (tcs != null) {for (io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item :tcs){ this.addToTcs(item);}} return (A) this;
    }

    public java.lang.Boolean hasTcs() {
        return tcs != null && !tcs.isEmpty();
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> addNewTc() {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.TcsNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> addNewTcLike(io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item) {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.TcsNestedImpl(-1, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> setNewTcLike(int index,io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item) {
        return new io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluentImpl.TcsNestedImpl(index, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> editTc(int index) {
        if (tcs.size() <= index) throw new RuntimeException("Can't edit tcs. Index exceeds size.");
        return setNewTcLike(index, buildTc(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> editFirstTc() {
        if (tcs.size() == 0) throw new RuntimeException("Can't edit first tcs. The list is empty.");
        return setNewTcLike(0, buildTc(0));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> editLastTc() {
        int index = tcs.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tcs. The list is empty.");
        return setNewTcLike(index, buildTc(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<A> editMatchingTc(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tcs.size();i++) { 
        if (predicate.test(tcs.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tcs. No match found.");
        return setNewTcLike(index, buildTc(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodNetworkChaosSpecFluentImpl that = (PodNetworkChaosSpecFluentImpl) o;
        if (ipsets != null ? !ipsets.equals(that.ipsets) :that.ipsets != null) return false;
        if (iptables != null ? !iptables.equals(that.iptables) :that.iptables != null) return false;
        if (tcs != null ? !tcs.equals(that.tcs) :that.tcs != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ipsets,  iptables,  tcs,  super.hashCode());
    }

    public class IpsetsNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.RawIPSetFluentImpl<io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<N>> implements io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IpsetsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder builder;
        private final int index;

            IpsetsNestedImpl(int index,io.fabric8.chaosmesh.v1alpha1.RawIPSet item) {
                this.index = index;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(this, item);
                        
            }

            IpsetsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.RawIPSetBuilder(this);
                        
            }

            public N and() {
                return (N) PodNetworkChaosSpecFluentImpl.this.setToIpsets(index,builder.build());
            }

            public N endIpset() {
                return and();
            }
    }


    public class IptablesNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.RawIptablesFluentImpl<io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<N>> implements io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.IptablesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder builder;
        private final int index;

            IptablesNestedImpl(int index,io.fabric8.chaosmesh.v1alpha1.RawIptables item) {
                this.index = index;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(this, item);
                        
            }

            IptablesNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.RawIptablesBuilder(this);
                        
            }

            public N and() {
                return (N) PodNetworkChaosSpecFluentImpl.this.setToIptables(index,builder.build());
            }

            public N endIptable() {
                return and();
            }
    }


    public class TcsNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.RawTrafficControlFluentImpl<io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<N>> implements io.fabric8.chaosmesh.v1alpha1.PodNetworkChaosSpecFluent.TcsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder builder;
        private final int index;

            TcsNestedImpl(int index,io.fabric8.chaosmesh.v1alpha1.RawTrafficControl item) {
                this.index = index;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(this, item);
                        
            }

            TcsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.RawTrafficControlBuilder(this);
                        
            }

            public N and() {
                return (N) PodNetworkChaosSpecFluentImpl.this.setToTcs(index,builder.build());
            }

            public N endTc() {
                return and();
            }
    }


}
