/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.chaosmesh.v1alpha1.RawIptables;
import io.fabric8.chaosmesh.v1alpha1.RawIptablesFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RawIptablesFluentImpl<A extends RawIptablesFluent<A>>
extends BaseFluent<A>
implements RawIptablesFluent<A> {
    private String direction;
    private List<String> ipsets;
    private String name;
    private String source;

    public RawIptablesFluentImpl() {
    }

    public RawIptablesFluentImpl(RawIptables instance) {
        this.withDirection(instance.getDirection());
        this.withIpsets(instance.getIpsets());
        this.withName(instance.getName());
        this.withSource(instance.getSource());
    }

    @Override
    public String getDirection() {
        return this.direction;
    }

    @Override
    public A withDirection(String direction) {
        this.direction = direction;
        return (A)this;
    }

    @Override
    public Boolean hasDirection() {
        return this.direction != null;
    }

    @Override
    @Deprecated
    public A withNewDirection(String arg0) {
        return this.withDirection(new String(arg0));
    }

    @Override
    public A addToIpsets(int index, String item) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        this.ipsets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToIpsets(int index, String item) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        this.ipsets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToIpsets(String ... items) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipsets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToIpsets(Collection<String> items) {
        if (this.ipsets == null) {
            this.ipsets = new ArrayList<String>();
        }
        for (String item : items) {
            this.ipsets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromIpsets(String ... items) {
        for (String item : items) {
            if (this.ipsets == null) continue;
            this.ipsets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIpsets(Collection<String> items) {
        for (String item : items) {
            if (this.ipsets == null) continue;
            this.ipsets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getIpsets() {
        return this.ipsets;
    }

    @Override
    public String getIpset(int index) {
        return this.ipsets.get(index);
    }

    @Override
    public String getFirstIpset() {
        return this.ipsets.get(0);
    }

    @Override
    public String getLastIpset() {
        return this.ipsets.get(this.ipsets.size() - 1);
    }

    @Override
    public String getMatchingIpset(Predicate<String> predicate) {
        for (String item : this.ipsets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIpset(Predicate<String> predicate) {
        for (String item : this.ipsets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIpsets(List<String> ipsets) {
        if (this.ipsets != null) {
            this._visitables.get((Object)"ipsets").removeAll(this.ipsets);
        }
        if (ipsets != null) {
            this.ipsets = new ArrayList<String>();
            for (String item : ipsets) {
                this.addToIpsets(item);
            }
        } else {
            this.ipsets = null;
        }
        return (A)this;
    }

    @Override
    public A withIpsets(String ... ipsets) {
        if (this.ipsets != null) {
            this.ipsets.clear();
        }
        if (ipsets != null) {
            for (String item : ipsets) {
                this.addToIpsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpsets() {
        return this.ipsets != null && !this.ipsets.isEmpty();
    }

    @Override
    public A addNewIpset(String arg0) {
        return this.addToIpsets(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public A withSource(String source) {
        this.source = source;
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    @Deprecated
    public A withNewSource(String arg0) {
        return this.withSource(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawIptablesFluentImpl that = (RawIptablesFluentImpl)o;
        if (this.direction != null ? !this.direction.equals(that.direction) : that.direction != null) {
            return false;
        }
        if (this.ipsets != null ? !this.ipsets.equals(that.ipsets) : that.ipsets != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    public int hashCode() {
        return Objects.hash(this.direction, this.ipsets, this.name, this.source, super.hashCode());
    }
}

