
package io.fabric8.chaosmesh.v1alpha1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "action",
    "cfl",
    "delay",
    "delay4servlet",
    "duration",
    "effectcount",
    "effectpercent",
    "mode",
    "oom",
    "return",
    "scheduler",
    "script",
    "selector",
    "tce",
    "tce4servlet",
    "value"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class JVMChaosSpec implements KubernetesResource
{

    @JsonProperty("action")
    private java.lang.String action;
    @JsonProperty("cfl")
    private JVMCpufullloadSpec cfl;
    @JsonProperty("delay")
    private JVMDelaySpec delay;
    @JsonProperty("delay4servlet")
    private ServletDelaySpec delay4servlet;
    @JsonProperty("duration")
    private String duration;
    @JsonProperty("effectcount")
    private Integer effectcount;
    @JsonProperty("effectpercent")
    private Integer effectpercent;
    @JsonProperty("mode")
    private java.lang.String mode;
    @JsonProperty("oom")
    private JVMOOMSpec oom;
    @JsonProperty("return")
    private JVMReturnSpec _return;
    @JsonProperty("scheduler")
    private SchedulerSpec scheduler;
    @JsonProperty("script")
    private JVMScriptSpec script;
    @JsonProperty("selector")
    private SelectorSpec selector;
    @JsonProperty("tce")
    private JVMExceptionSpec tce;
    @JsonProperty("tce4servlet")
    private ServletExceptionSpec tce4servlet;
    @JsonProperty("value")
    private java.lang.String value;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public JVMChaosSpec() {
    }

    /**
     * 
     * @param effectcount
     * @param cfl
     * @param oom
     * @param effectpercent
     * @param script
     * @param tce4servlet
     * @param duration
     * @param mode
     * @param scheduler
     * @param _return
     * @param delay
     * @param tce
     * @param action
     * @param delay4servlet
     * @param selector
     * @param value
     */
    public JVMChaosSpec(java.lang.String action, JVMCpufullloadSpec cfl, JVMDelaySpec delay, ServletDelaySpec delay4servlet, String duration, Integer effectcount, Integer effectpercent, java.lang.String mode, JVMOOMSpec oom, JVMReturnSpec _return, SchedulerSpec scheduler, JVMScriptSpec script, SelectorSpec selector, JVMExceptionSpec tce, ServletExceptionSpec tce4servlet, java.lang.String value) {
        super();
        this.action = action;
        this.cfl = cfl;
        this.delay = delay;
        this.delay4servlet = delay4servlet;
        this.duration = duration;
        this.effectcount = effectcount;
        this.effectpercent = effectpercent;
        this.mode = mode;
        this.oom = oom;
        this._return = _return;
        this.scheduler = scheduler;
        this.script = script;
        this.selector = selector;
        this.tce = tce;
        this.tce4servlet = tce4servlet;
        this.value = value;
    }

    @JsonProperty("action")
    public java.lang.String getAction() {
        return action;
    }

    @JsonProperty("action")
    public void setAction(java.lang.String action) {
        this.action = action;
    }

    @JsonProperty("cfl")
    public JVMCpufullloadSpec getCfl() {
        return cfl;
    }

    @JsonProperty("cfl")
    public void setCfl(JVMCpufullloadSpec cfl) {
        this.cfl = cfl;
    }

    @JsonProperty("delay")
    public JVMDelaySpec getDelay() {
        return delay;
    }

    @JsonProperty("delay")
    public void setDelay(JVMDelaySpec delay) {
        this.delay = delay;
    }

    @JsonProperty("delay4servlet")
    public ServletDelaySpec getDelay4servlet() {
        return delay4servlet;
    }

    @JsonProperty("delay4servlet")
    public void setDelay4servlet(ServletDelaySpec delay4servlet) {
        this.delay4servlet = delay4servlet;
    }

    @JsonProperty("duration")
    public String getDuration() {
        return duration;
    }

    @JsonProperty("duration")
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @JsonProperty("effectcount")
    public Integer getEffectcount() {
        return effectcount;
    }

    @JsonProperty("effectcount")
    public void setEffectcount(Integer effectcount) {
        this.effectcount = effectcount;
    }

    @JsonProperty("effectpercent")
    public Integer getEffectpercent() {
        return effectpercent;
    }

    @JsonProperty("effectpercent")
    public void setEffectpercent(Integer effectpercent) {
        this.effectpercent = effectpercent;
    }

    @JsonProperty("mode")
    public java.lang.String getMode() {
        return mode;
    }

    @JsonProperty("mode")
    public void setMode(java.lang.String mode) {
        this.mode = mode;
    }

    @JsonProperty("oom")
    public JVMOOMSpec getOom() {
        return oom;
    }

    @JsonProperty("oom")
    public void setOom(JVMOOMSpec oom) {
        this.oom = oom;
    }

    @JsonProperty("return")
    public JVMReturnSpec getReturn() {
        return _return;
    }

    @JsonProperty("return")
    public void setReturn(JVMReturnSpec _return) {
        this._return = _return;
    }

    @JsonProperty("scheduler")
    public SchedulerSpec getScheduler() {
        return scheduler;
    }

    @JsonProperty("scheduler")
    public void setScheduler(SchedulerSpec scheduler) {
        this.scheduler = scheduler;
    }

    @JsonProperty("script")
    public JVMScriptSpec getScript() {
        return script;
    }

    @JsonProperty("script")
    public void setScript(JVMScriptSpec script) {
        this.script = script;
    }

    @JsonProperty("selector")
    public SelectorSpec getSelector() {
        return selector;
    }

    @JsonProperty("selector")
    public void setSelector(SelectorSpec selector) {
        this.selector = selector;
    }

    @JsonProperty("tce")
    public JVMExceptionSpec getTce() {
        return tce;
    }

    @JsonProperty("tce")
    public void setTce(JVMExceptionSpec tce) {
        this.tce = tce;
    }

    @JsonProperty("tce4servlet")
    public ServletExceptionSpec getTce4servlet() {
        return tce4servlet;
    }

    @JsonProperty("tce4servlet")
    public void setTce4servlet(ServletExceptionSpec tce4servlet) {
        this.tce4servlet = tce4servlet;
    }

    @JsonProperty("value")
    public java.lang.String getValue() {
        return value;
    }

    @JsonProperty("value")
    public void setValue(java.lang.String value) {
        this.value = value;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
