package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class HTTPChaosSpecFluentImpl<A extends io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent<A> {

    private java.lang.String action;
    private java.lang.String duration;
    private java.util.List<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder> headers;
    private java.lang.String mode;
    private java.lang.String percent;
    private io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder scheduler;
    private io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder selector;
    private java.lang.String value;

    public HTTPChaosSpecFluentImpl() {
    }

    public HTTPChaosSpecFluentImpl(io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpec instance) {
        this.withAction(instance.getAction()); 
        this.withDuration(instance.getDuration()); 
        this.withHeaders(instance.getHeaders()); 
        this.withMode(instance.getMode()); 
        this.withPercent(instance.getPercent()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
    }

    public java.lang.String getAction() {
        return this.action;
    }

    public A withAction(java.lang.String action) {
        this.action=action; return (A) this;
    }

    public java.lang.Boolean hasAction() {
        return this.action != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withAction instead.
     */
        public A withNewAction(java.lang.String arg0) {
        return (A)withAction(new String(arg0));
    }

    public java.lang.String getDuration() {
        return this.duration;
    }

    public A withDuration(java.lang.String duration) {
        this.duration=duration; return (A) this;
    }

    public java.lang.Boolean hasDuration() {
        return this.duration != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDuration instead.
     */
        public A withNewDuration(java.lang.String arg0) {
        return (A)withDuration(new String(arg0));
    }

    public A addToHeaders(int index,io.fabric8.chaosmesh.v1alpha1.Matcher item) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(item);_visitables.get("headers").add(index >= 0 ? index : _visitables.get("headers").size(), builder);this.headers.add(index >= 0 ? index : headers.size(), builder); return (A)this;
    }

    public A setToHeaders(int index,io.fabric8.chaosmesh.v1alpha1.Matcher item) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder>();}
        io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(item);
        if (index < 0 || index >= _visitables.get("headers").size()) { _visitables.get("headers").add(builder); } else { _visitables.get("headers").set(index, builder);}
        if (index < 0 || index >= headers.size()) { headers.add(builder); } else { headers.set(index, builder);}
         return (A)this;
    }

    public A addToHeaders(io.fabric8.chaosmesh.v1alpha1.Matcher... items) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.Matcher item : items) {io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
    }

    public A addAllToHeaders(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.Matcher> items) {
        if (this.headers == null) {this.headers = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder>();}
        for (io.fabric8.chaosmesh.v1alpha1.Matcher item : items) {io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(item);_visitables.get("headers").add(builder);this.headers.add(builder);} return (A)this;
    }

    public A removeFromHeaders(io.fabric8.chaosmesh.v1alpha1.Matcher... items) {
        for (io.fabric8.chaosmesh.v1alpha1.Matcher item : items) {io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
    }

    public A removeAllFromHeaders(java.util.Collection<io.fabric8.chaosmesh.v1alpha1.Matcher> items) {
        for (io.fabric8.chaosmesh.v1alpha1.Matcher item : items) {io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(item);_visitables.get("headers").remove(builder);if (this.headers != null) {this.headers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHeaders(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder> predicate) {
        if (headers == null) return (A) this;
        final Iterator<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder> each = headers.iterator();
        final List visitables = _visitables.get("headers");
        while (each.hasNext()) {
          io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildHeaders instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.chaosmesh.v1alpha1.Matcher> getHeaders() {
        return build(headers);
    }

    public java.util.List<io.fabric8.chaosmesh.v1alpha1.Matcher> buildHeaders() {
        return build(headers);
    }

    public io.fabric8.chaosmesh.v1alpha1.Matcher buildHeader(int index) {
        return this.headers.get(index).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.Matcher buildFirstHeader() {
        return this.headers.get(0).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.Matcher buildLastHeader() {
        return this.headers.get(headers.size() - 1).build();
    }

    public io.fabric8.chaosmesh.v1alpha1.Matcher buildMatchingHeader(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.MatcherBuilder item: headers) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingHeader(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder> predicate) {
        for (io.fabric8.chaosmesh.v1alpha1.MatcherBuilder item: headers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHeaders(java.util.List<io.fabric8.chaosmesh.v1alpha1.Matcher> headers) {
        if (this.headers != null) { _visitables.get("headers").removeAll(this.headers);}
        if (headers != null) {this.headers = new java.util.ArrayList<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder>(); for (io.fabric8.chaosmesh.v1alpha1.Matcher item : headers){this.addToHeaders(item);}} else { this.headers = null;} return (A) this;
    }

    public A withHeaders(io.fabric8.chaosmesh.v1alpha1.Matcher... headers) {
        if (this.headers != null) {this.headers.clear();}
        if (headers != null) {for (io.fabric8.chaosmesh.v1alpha1.Matcher item :headers){ this.addToHeaders(item);}} return (A) this;
    }

    public java.lang.Boolean hasHeaders() {
        return headers != null && !headers.isEmpty();
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> addNewHeader() {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.HeadersNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> addNewHeaderLike(io.fabric8.chaosmesh.v1alpha1.Matcher item) {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.HeadersNestedImpl(-1, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> setNewHeaderLike(int index,io.fabric8.chaosmesh.v1alpha1.Matcher item) {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.HeadersNestedImpl(index, item);
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> editHeader(int index) {
        if (headers.size() <= index) throw new RuntimeException("Can't edit headers. Index exceeds size.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> editFirstHeader() {
        if (headers.size() == 0) throw new RuntimeException("Can't edit first headers. The list is empty.");
        return setNewHeaderLike(0, buildHeader(0));
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> editLastHeader() {
        int index = headers.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last headers. The list is empty.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<A> editMatchingHeader(java.util.function.Predicate<io.fabric8.chaosmesh.v1alpha1.MatcherBuilder> predicate) {
        int index = -1;
        for (int i=0;i<headers.size();i++) { 
        if (predicate.test(headers.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching headers. No match found.");
        return setNewHeaderLike(index, buildHeader(index));
    }

    public java.lang.String getMode() {
        return this.mode;
    }

    public A withMode(java.lang.String mode) {
        this.mode=mode; return (A) this;
    }

    public java.lang.Boolean hasMode() {
        return this.mode != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMode instead.
     */
        public A withNewMode(java.lang.String arg0) {
        return (A)withMode(new String(arg0));
    }

    public java.lang.String getPercent() {
        return this.percent;
    }

    public A withPercent(java.lang.String percent) {
        this.percent=percent; return (A) this;
    }

    public java.lang.Boolean hasPercent() {
        return this.percent != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPercent instead.
     */
        public A withNewPercent(java.lang.String arg0) {
        return (A)withPercent(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildScheduler instead.
     * @return The buildable object.
     */
        public io.fabric8.chaosmesh.v1alpha1.SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public io.fabric8.chaosmesh.v1alpha1.SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public java.lang.Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(java.lang.String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.SchedulerNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec item) {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.SchedulerNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.chaosmesh.v1alpha1.SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public io.fabric8.chaosmesh.v1alpha1.SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.chaosmesh.v1alpha1.SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.SelectorNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.chaosmesh.v1alpha1.SelectorSpec item) {
        return new io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluentImpl.SelectorNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.chaosmesh.v1alpha1.SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public java.lang.String getValue() {
        return this.value;
    }

    public A withValue(java.lang.String value) {
        this.value=value; return (A) this;
    }

    public java.lang.Boolean hasValue() {
        return this.value != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withValue instead.
     */
        public A withNewValue(java.lang.String arg0) {
        return (A)withValue(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HTTPChaosSpecFluentImpl that = (HTTPChaosSpecFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  duration,  headers,  mode,  percent,  scheduler,  selector,  value,  super.hashCode());
    }

    public class HeadersNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.MatcherFluentImpl<io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<N>> implements io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.HeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.MatcherBuilder builder;
        private final int index;

            HeadersNestedImpl(int index,io.fabric8.chaosmesh.v1alpha1.Matcher item) {
                this.index = index;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(this, item);
                        
            }

            HeadersNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.chaosmesh.v1alpha1.MatcherBuilder(this);
                        
            }

            public N and() {
                return (N) HTTPChaosSpecFluentImpl.this.setToHeaders(index,builder.build());
            }

            public N endHeader() {
                return and();
            }
    }


    public class SchedulerNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.SchedulerSpecFluentImpl<io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<N>> implements io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder builder;

            SchedulerNestedImpl(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec item) {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) HTTPChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.SelectorSpecFluentImpl<io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<N>> implements io.fabric8.chaosmesh.v1alpha1.HTTPChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder builder;

            SelectorNestedImpl(io.fabric8.chaosmesh.v1alpha1.SelectorSpec item) {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) HTTPChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
