package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class TimeChaosSpecFluentImpl<A extends io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent<A> {

    private java.util.List<java.lang.String> clockIds;
    private java.util.List<java.lang.String> containerNames;
    private java.lang.String duration;
    private java.lang.String mode;
    private io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder scheduler;
    private io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder selector;
    private java.lang.String timeOffset;
    private java.lang.String value;

    public TimeChaosSpecFluentImpl() {
    }

    public TimeChaosSpecFluentImpl(io.fabric8.chaosmesh.v1alpha1.TimeChaosSpec instance) {
        this.withClockIds(instance.getClockIds()); 
        this.withContainerNames(instance.getContainerNames()); 
        this.withDuration(instance.getDuration()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withTimeOffset(instance.getTimeOffset()); 
        this.withValue(instance.getValue()); 
    }

    public A addToClockIds(int index,java.lang.String item) {
        if (this.clockIds == null) {this.clockIds = new java.util.ArrayList<java.lang.String>();}
        this.clockIds.add(index, item);
        return (A)this;
    }

    public A setToClockIds(int index,java.lang.String item) {
        if (this.clockIds == null) {this.clockIds = new java.util.ArrayList<java.lang.String>();}
        this.clockIds.set(index, item); return (A)this;
    }

    public A addToClockIds(java.lang.String... items) {
        if (this.clockIds == null) {this.clockIds = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.clockIds.add(item);} return (A)this;
    }

    public A addAllToClockIds(java.util.Collection<java.lang.String> items) {
        if (this.clockIds == null) {this.clockIds = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.clockIds.add(item);} return (A)this;
    }

    public A removeFromClockIds(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.clockIds!= null){ this.clockIds.remove(item);}} return (A)this;
    }

    public A removeAllFromClockIds(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.clockIds!= null){ this.clockIds.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getClockIds() {
        return this.clockIds;
    }

    public java.lang.String getClockId(int index) {
        return this.clockIds.get(index);
    }

    public java.lang.String getFirstClockId() {
        return this.clockIds.get(0);
    }

    public java.lang.String getLastClockId() {
        return this.clockIds.get(clockIds.size() - 1);
    }

    public java.lang.String getMatchingClockId(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: clockIds) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingClockId(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: clockIds) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClockIds(java.util.List<java.lang.String> clockIds) {
        if (this.clockIds != null) { _visitables.get("clockIds").removeAll(this.clockIds);}
        if (clockIds != null) {this.clockIds = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : clockIds){this.addToClockIds(item);}} else { this.clockIds = null;} return (A) this;
    }

    public A withClockIds(java.lang.String... clockIds) {
        if (this.clockIds != null) {this.clockIds.clear();}
        if (clockIds != null) {for (java.lang.String item :clockIds){ this.addToClockIds(item);}} return (A) this;
    }

    public java.lang.Boolean hasClockIds() {
        return clockIds != null && !clockIds.isEmpty();
    }

    public A addNewClockId(java.lang.String arg0) {
        return (A)addToClockIds(new String(arg0));
    }

    public A addToContainerNames(int index,java.lang.String item) {
        if (this.containerNames == null) {this.containerNames = new java.util.ArrayList<java.lang.String>();}
        this.containerNames.add(index, item);
        return (A)this;
    }

    public A setToContainerNames(int index,java.lang.String item) {
        if (this.containerNames == null) {this.containerNames = new java.util.ArrayList<java.lang.String>();}
        this.containerNames.set(index, item); return (A)this;
    }

    public A addToContainerNames(java.lang.String... items) {
        if (this.containerNames == null) {this.containerNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.containerNames.add(item);} return (A)this;
    }

    public A addAllToContainerNames(java.util.Collection<java.lang.String> items) {
        if (this.containerNames == null) {this.containerNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.containerNames.add(item);} return (A)this;
    }

    public A removeFromContainerNames(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
    }

    public A removeAllFromContainerNames(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getContainerNames() {
        return this.containerNames;
    }

    public java.lang.String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    public java.lang.String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    public java.lang.String getLastContainerName() {
        return this.containerNames.get(containerNames.size() - 1);
    }

    public java.lang.String getMatchingContainerName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingContainerName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContainerNames(java.util.List<java.lang.String> containerNames) {
        if (this.containerNames != null) { _visitables.get("containerNames").removeAll(this.containerNames);}
        if (containerNames != null) {this.containerNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
    }

    public A withContainerNames(java.lang.String... containerNames) {
        if (this.containerNames != null) {this.containerNames.clear();}
        if (containerNames != null) {for (java.lang.String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
    }

    public java.lang.Boolean hasContainerNames() {
        return containerNames != null && !containerNames.isEmpty();
    }

    public A addNewContainerName(java.lang.String arg0) {
        return (A)addToContainerNames(new String(arg0));
    }

    public java.lang.String getDuration() {
        return this.duration;
    }

    public A withDuration(java.lang.String duration) {
        this.duration=duration; return (A) this;
    }

    public java.lang.Boolean hasDuration() {
        return this.duration != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDuration instead.
     */
        public A withNewDuration(java.lang.String arg0) {
        return (A)withDuration(new String(arg0));
    }

    public java.lang.String getMode() {
        return this.mode;
    }

    public A withMode(java.lang.String mode) {
        this.mode=mode; return (A) this;
    }

    public java.lang.Boolean hasMode() {
        return this.mode != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMode instead.
     */
        public A withNewMode(java.lang.String arg0) {
        return (A)withMode(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildScheduler instead.
     * @return The buildable object.
     */
        public io.fabric8.chaosmesh.v1alpha1.SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public io.fabric8.chaosmesh.v1alpha1.SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public java.lang.Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(java.lang.String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluentImpl.SchedulerNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec item) {
        return new io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluentImpl.SchedulerNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.chaosmesh.v1alpha1.SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public io.fabric8.chaosmesh.v1alpha1.SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(io.fabric8.chaosmesh.v1alpha1.SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluentImpl.SelectorNestedImpl();
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.chaosmesh.v1alpha1.SelectorSpec item) {
        return new io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluentImpl.SelectorNestedImpl(item);
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder().build());
    }

    public io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.chaosmesh.v1alpha1.SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public java.lang.String getTimeOffset() {
        return this.timeOffset;
    }

    public A withTimeOffset(java.lang.String timeOffset) {
        this.timeOffset=timeOffset; return (A) this;
    }

    public java.lang.Boolean hasTimeOffset() {
        return this.timeOffset != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTimeOffset instead.
     */
        public A withNewTimeOffset(java.lang.String arg0) {
        return (A)withTimeOffset(new String(arg0));
    }

    public java.lang.String getValue() {
        return this.value;
    }

    public A withValue(java.lang.String value) {
        this.value=value; return (A) this;
    }

    public java.lang.Boolean hasValue() {
        return this.value != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withValue instead.
     */
        public A withNewValue(java.lang.String arg0) {
        return (A)withValue(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TimeChaosSpecFluentImpl that = (TimeChaosSpecFluentImpl) o;
        if (clockIds != null ? !clockIds.equals(that.clockIds) :that.clockIds != null) return false;
        if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (timeOffset != null ? !timeOffset.equals(that.timeOffset) :that.timeOffset != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clockIds,  containerNames,  duration,  mode,  scheduler,  selector,  timeOffset,  value,  super.hashCode());
    }

    public class SchedulerNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.SchedulerSpecFluentImpl<io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<N>> implements io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder builder;

            SchedulerNestedImpl(io.fabric8.chaosmesh.v1alpha1.SchedulerSpec item) {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) TimeChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends io.fabric8.chaosmesh.v1alpha1.SelectorSpecFluentImpl<io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<N>> implements io.fabric8.chaosmesh.v1alpha1.TimeChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder builder;

            SelectorNestedImpl(io.fabric8.chaosmesh.v1alpha1.SelectorSpec item) {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new io.fabric8.chaosmesh.v1alpha1.SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) TimeChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
