package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StressorsBuilder extends StressorsFluentImpl<StressorsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Stressors,StressorsBuilder> {

    StressorsFluent<?> fluent;
    Boolean validationEnabled;

    public StressorsBuilder() {
        this(true);
    }

    public StressorsBuilder(Boolean validationEnabled) {
        this(new Stressors(), validationEnabled);
    }

    public StressorsBuilder(StressorsFluent<?> fluent) {
        this(fluent, true);
    }

    public StressorsBuilder(StressorsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Stressors(), validationEnabled);
    }

    public StressorsBuilder(StressorsFluent<?> fluent,Stressors instance) {
        this(fluent, instance, true);
    }

    public StressorsBuilder(StressorsFluent<?> fluent,Stressors instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCpu(instance.getCpu()); 
        fluent.withMemory(instance.getMemory()); 
        this.validationEnabled = validationEnabled; 
    }

    public StressorsBuilder(Stressors instance) {
        this(instance,true);
    }

    public StressorsBuilder(Stressors instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCpu(instance.getCpu()); 
        this.withMemory(instance.getMemory()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableStressors build() {
        EditableStressors buildable = new EditableStressors(fluent.getCpu(),fluent.getMemory());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StressorsBuilder that = (StressorsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
