package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StressChaosBuilder extends StressChaosFluentImpl<StressChaosBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<StressChaos,StressChaosBuilder> {

    StressChaosFluent<?> fluent;
    Boolean validationEnabled;

    public StressChaosBuilder() {
        this(true);
    }

    public StressChaosBuilder(Boolean validationEnabled) {
        this(new StressChaos(), validationEnabled);
    }

    public StressChaosBuilder(StressChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public StressChaosBuilder(StressChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new StressChaos(), validationEnabled);
    }

    public StressChaosBuilder(StressChaosFluent<?> fluent,StressChaos instance) {
        this(fluent, instance, true);
    }

    public StressChaosBuilder(StressChaosFluent<?> fluent,StressChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public StressChaosBuilder(StressChaos instance) {
        this(instance,true);
    }

    public StressChaosBuilder(StressChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableStressChaos build() {
        EditableStressChaos buildable = new EditableStressChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StressChaosBuilder that = (StressChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
