package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServletExceptionSpecBuilder extends ServletExceptionSpecFluentImpl<ServletExceptionSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ServletExceptionSpec,ServletExceptionSpecBuilder> {

    ServletExceptionSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServletExceptionSpecBuilder() {
        this(true);
    }

    public ServletExceptionSpecBuilder(Boolean validationEnabled) {
        this(new ServletExceptionSpec(), validationEnabled);
    }

    public ServletExceptionSpecBuilder(ServletExceptionSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ServletExceptionSpecBuilder(ServletExceptionSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServletExceptionSpec(), validationEnabled);
    }

    public ServletExceptionSpecBuilder(ServletExceptionSpecFluent<?> fluent,ServletExceptionSpec instance) {
        this(fluent, instance, true);
    }

    public ServletExceptionSpecBuilder(ServletExceptionSpecFluent<?> fluent,ServletExceptionSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withException(instance.getException()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withMethod(instance.getMethod()); 
        fluent.withQuerystring(instance.getQuerystring()); 
        fluent.withRequestpath(instance.getRequestpath()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServletExceptionSpecBuilder(ServletExceptionSpec instance) {
        this(instance,true);
    }

    public ServletExceptionSpecBuilder(ServletExceptionSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withException(instance.getException()); 
        this.withMessage(instance.getMessage()); 
        this.withMethod(instance.getMethod()); 
        this.withQuerystring(instance.getQuerystring()); 
        this.withRequestpath(instance.getRequestpath()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableServletExceptionSpec build() {
        EditableServletExceptionSpec buildable = new EditableServletExceptionSpec(fluent.getException(),fluent.getMessage(),fluent.getMethod(),fluent.getQuerystring(),fluent.getRequestpath());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServletExceptionSpecBuilder that = (ServletExceptionSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
