package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodIoChaosListBuilder extends PodIoChaosListFluentImpl<PodIoChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodIoChaosList,PodIoChaosListBuilder> {

    PodIoChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public PodIoChaosListBuilder() {
        this(true);
    }

    public PodIoChaosListBuilder(Boolean validationEnabled) {
        this(new PodIoChaosList(), validationEnabled);
    }

    public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodIoChaosList(), validationEnabled);
    }

    public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent,PodIoChaosList instance) {
        this(fluent, instance, true);
    }

    public PodIoChaosListBuilder(PodIoChaosListFluent<?> fluent,PodIoChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodIoChaosListBuilder(PodIoChaosList instance) {
        this(instance,true);
    }

    public PodIoChaosListBuilder(PodIoChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditablePodIoChaosList build() {
        EditablePodIoChaosList buildable = new EditablePodIoChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodIoChaosListBuilder that = (PodIoChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
