package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodChaosBuilder extends PodChaosFluentImpl<PodChaosBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<PodChaos,PodChaosBuilder> {

    PodChaosFluent<?> fluent;
    Boolean validationEnabled;

    public PodChaosBuilder() {
        this(true);
    }

    public PodChaosBuilder(Boolean validationEnabled) {
        this(new PodChaos(), validationEnabled);
    }

    public PodChaosBuilder(PodChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public PodChaosBuilder(PodChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PodChaos(), validationEnabled);
    }

    public PodChaosBuilder(PodChaosFluent<?> fluent,PodChaos instance) {
        this(fluent, instance, true);
    }

    public PodChaosBuilder(PodChaosFluent<?> fluent,PodChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public PodChaosBuilder(PodChaos instance) {
        this(instance,true);
    }

    public PodChaosBuilder(PodChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditablePodChaos build() {
        EditablePodChaos buildable = new EditablePodChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodChaosBuilder that = (PodChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
