package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkChaosListBuilder extends NetworkChaosListFluentImpl<NetworkChaosListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<NetworkChaosList,NetworkChaosListBuilder> {

    NetworkChaosListFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkChaosListBuilder() {
        this(true);
    }

    public NetworkChaosListBuilder(Boolean validationEnabled) {
        this(new NetworkChaosList(), validationEnabled);
    }

    public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NetworkChaosList(), validationEnabled);
    }

    public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent,NetworkChaosList instance) {
        this(fluent, instance, true);
    }

    public NetworkChaosListBuilder(NetworkChaosListFluent<?> fluent,NetworkChaosList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkChaosListBuilder(NetworkChaosList instance) {
        this(instance,true);
    }

    public NetworkChaosListBuilder(NetworkChaosList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableNetworkChaosList build() {
        EditableNetworkChaosList buildable = new EditableNetworkChaosList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkChaosListBuilder that = (NetworkChaosListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
