package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MemoryStressorBuilder extends MemoryStressorFluentImpl<MemoryStressorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<MemoryStressor,MemoryStressorBuilder> {

    MemoryStressorFluent<?> fluent;
    Boolean validationEnabled;

    public MemoryStressorBuilder() {
        this(true);
    }

    public MemoryStressorBuilder(Boolean validationEnabled) {
        this(new MemoryStressor(), validationEnabled);
    }

    public MemoryStressorBuilder(MemoryStressorFluent<?> fluent) {
        this(fluent, true);
    }

    public MemoryStressorBuilder(MemoryStressorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MemoryStressor(), validationEnabled);
    }

    public MemoryStressorBuilder(MemoryStressorFluent<?> fluent,MemoryStressor instance) {
        this(fluent, instance, true);
    }

    public MemoryStressorBuilder(MemoryStressorFluent<?> fluent,MemoryStressor instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOptions(instance.getOptions()); 
        fluent.withWorkers(instance.getWorkers()); 
        this.validationEnabled = validationEnabled; 
    }

    public MemoryStressorBuilder(MemoryStressor instance) {
        this(instance,true);
    }

    public MemoryStressorBuilder(MemoryStressor instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withOptions(instance.getOptions()); 
        this.withWorkers(instance.getWorkers()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableMemoryStressor build() {
        EditableMemoryStressor buildable = new EditableMemoryStressor(fluent.getOptions(),fluent.getWorkers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MemoryStressorBuilder that = (MemoryStressorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
